# -*- coding: UTF-8 -*-
import traceback
import common

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : check remote device link status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show remote_device link"
        PY_LOGGER.info("Sequence[82] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.cliExecRetJudgeWithDoubleList(cli,cmd,lang,True)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if common.CHECK_NOPASS == checkRet[0]:
            PY_LOGGER.info("Sequence[82] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)        
        #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
        elif common.CHECK_PASS == checkRet[0]:
            return (True, cliRet, "")
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        list = cliRet.splitlines()
        i = 0
        linkId=""
        #巡检项检查结果优化 modified Begin
        for field in list:          
            i = i+1
            if i > 5:
                list1 = field.split()
                if len(list1)<1:
                    continue
                
                if "FC" == list1[0] or "ISCSI" == list1[0] or -1!=field.find("------") or "ID" == list1[0]:
                    continue
                
                if common.isEndLine(list1[0]):
                    break
                
                if (len(list1) >= 8):
                    if -1==field.find("Normal"):
                        flag = False
                        if len(list1)>0:
                            linkId = list1[0]
                            if "zh" == lang:
                                errMsg += u"\n远端设备链路ID[" + linkId + u"]状态检查异常"
                            else:
                                errMsg += "\nThe status of remote device link [" + linkId + "] is abnormal"

        if not flag:
             PY_LOGGER.info("Sequence[82] inspect not pass.")

        return (flag, cliRet, errMsg)
        #巡检项检查结果优化 modified End
    except Exception, exception:
        PY_LOGGER.error("Sequence[82] catch except of check remote device link status.")
        PY_LOGGER.error("Sequence[82] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[82] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[82] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)
