# -*- coding: UTF-8 -*-
import traceback
import common
G_RETRY_TIMES = 30

def execute(cli):
    """
    Create date        : 2012/05/18
    Function describe  : check mirror general status
    Input              : cli--Telnet acess proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        cliRet = ""
    	errMsg = ""

        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified Begin
        #执行的CLI命令
        cmd = "show clone general"
        PY_LOGGER.info("Sequence[85] begin to inspect, exec cli command:"+str(cmd))
        #CLI命令执行后，通过接口初步判断命令是否执行成功，异常情况直接返回，巡检不通过，相关详细描述信息在公共接口里面设置
        checkRet =  common.cliExecRetWithTimeout(cli,cmd,G_RETRY_TIMES,lang)
        cliRet = checkRet[1]
        errMsg = checkRet[2]
        if common.CHECK_NOPASS == checkRet[0]:
            PY_LOGGER.info("Sequence[85] inspect not pass. (system abnormal!)")
            return (False, cliRet, errMsg)        
        #命令执行后包含Command executed successfully等标志，直接退出，巡检通过
        elif common.CHECK_PASS == checkRet[0]:
            return (True, cliRet, "")
        #小系统，闪断，异常掉电，超时等增加统一的错误处理， modified End
        
        list = cliRet.splitlines()
        if len(list)>2:
            if -1!=list[1].find("^"):
                if "zh" == lang:
                    errMsg = u"\n当前版本不支持此命令"
                else:
                    errMsg = "\nCommand not support at current vesion"
                return (flag, cliRet, errMsg)
            
        i = 0
        for field in list:
            i = i+1
            if i > 4:
                list1 = field.split()
                if common.isEndLine(list1[0]):
                    break
                    
                if (len(list1) >= 7) and ("Normal" != list1[2]):
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n克隆[" + list1[0] + u"]状态检查异常"
                    else:
                         errMsg += "\nThe status of clone ["+list1[0]+"] is abnormal"  
        if not flag:
             PY_LOGGER.debug ("Sequence[85] inspect not pass.")
             
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[85] catch except of check mirror general status.")
        PY_LOGGER.error("Sequence[85] catch except of arguement:" + str(exception.args))
        PY_LOGGER.error("Sequence[85] catch except of messages:" + str(exception))
        PY_LOGGER.error("Sequence[85] catch except of trace back:" + str(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常"
        else:
            errMsg = "\nQuery result is abnormal"
        return (flag, cliRet, errMsg)

