# -*- coding: UTF-8 -*-
import traceback
import common
import re

#########################################
#      巡检前置脚本
# 巡检前检查设备是否正常，目前登录的用户模式
#########################################
PRODUCT_VESION = "V200R001C00"

# **************************************************************************** #
# 函数名称: isChinese
# 功能说明: 判断当前语言是否为中文
# 输入参数: 无
# 输出参数: True or False
# **************************************************************************** # 
def isChinese():
    lang = py_java_env.get("lang")
    if "zh"==lang:
        return True
    return False

# **************************************************************************** #
# 函数名称: isNormalSystem
# 功能说明: 判断系统是否处于正常模式，并带回不正常时提示的详细信息
# 输入参数: devObj
# 输出参数: True or False
# **************************************************************************** # 
def isNormalSystem(devObj):
    cliRet = ""
    errMsg = ""
    ssh =  devObj.get("ssh")
    lang = py_java_env.get("lang")
    
    cmd = "show system general"
    checkRet = common.isCliExecRetInBlackList(ssh, cmd, lang, True)
    cliRet = checkRet[1]
    errMsg = checkRet[2]
    
    #CLI回显异常，直接退出
    if checkRet[0]:
        return (False, cliRet, errMsg)
    
    #根据回显判断设备是否开工正常，Health Status及Running Status都要为Normal,版本号要正常
    healthStatus = ""
    runningStatus = ""
    productVersion = ""
    lineList = cliRet.splitlines()
    for line in lineList:
        line = line.replace(" ","")
        if line.startswith("HealthStatus:"):
            healthStatus = line.replace("HealthStatus:","")
        elif line.startswith("RunningStatus:"):
            runningStatus = line.replace("RunningStatus:","")
        elif line.startswith("ProductVersion:"):
            productVersion = line.replace("ProductVersion:","")
            break  
    
    if healthStatus not in ["normal", "Normal"]:
        if isChinese():
            errMsg =u"\n设备健康状态异常"+u"（"+healthStatus+u"）"
        else:     
            errMsg = "\nDevice health status is abnormal "+"("+healthStatus+")"
        return (False, cliRet, errMsg)
    
    if runningStatus not in ["normal", "Normal"]:
        if isChinese():
            errMsg =u"\n设备运行状态异常"+u"（"+runningStatus+u"）"
        else:     
            errMsg = "\nDevice running status is abnormal "+"("+runningStatus+")"
        return (False, cliRet, errMsg)
    
    if PRODUCT_VESION != productVersion:  
        if isChinese():
            errMsg =u"\n设备产品版本异常，非V200R001C00版本"+u"（"+productVersion+u"）"
        else:     
            errMsg = "\nDevice product version is abnormal, not V200R001C00 "+"("+productVersion+")"
        return (False, cliRet, errMsg)
    return (True, cliRet, errMsg)

#设置异常返回的提示信息，涉及到中英文

res_desc_zh = {'success': ur'系统检查通过', 
               'except':  ur'系统检查异常'
               }
                
res_desc_en = {'success': r'System check done',
               'except':  r'System check except'
               }
                 
res_desc = {'zh': res_desc_zh, 'en': res_desc_en} 

   
# **************************************************************************** #
# 函数名称: execute
# 功能说明: 执行巡检脚本之前判断，判断系统是否处于正常状态
# 输入参数: cliRet
# 输出参数: True or False
# **************************************************************************** # 
def execute(devObj):
    try:
        lang = ""
        if isChinese():
            lang = "zh"
        else:
            lang = "en"
        retMsg = isNormalSystem(devObj)
  
        if not retMsg[0]:
            return ('', dict(flag = False, des = retMsg[2]))
        
        return ('', dict(flag = True, des = res_desc[lang]['success']))
    
    except Exception, exception:
        return ('', dict(flag = False, des = res_desc[lang]['except']))
