# -*- coding: UTF-8 -*-
import traceback
import re
import cliModeManager
import hardware
MAX_RETRYS = 5


#modified 2013-12-16 begin
def getBBUNumDict(cli):
    ctrlNum = 0
    bbuNumDict = {}
    cliRet = cli.execCmd("show controller general")
    lines = cliRet.splitlines()

    for field in lines:
        field = field.replace(" ", "")
        if field.startswith("Controller:"):
            ctrlNum = ctrlNum + 1
            continue
    # 控制器BBU标准配置规格    
    if ctrlNum <= 2:
        bbuNumDict = {"S2600T":2, "S5500T":2, "S5600T":4, "S5800T":4, "S6800T":4}
    elif ctrlNum <= 4 and ctrlNum > 2:
        bbuNumDict = {"S5500T":4, "S5600T":8, "S5800T":8, "S6800T":8}
    return bbuNumDict
#modified 2013-12-16 end

#需要优化的检查项  modified 20131125 Begin
#####################################################
# 函数名称：checkBbuNum
# 功能说明：检测BBU个数是否达标
# 传入参数：cli连接，通过标识flag，错误信息errMsg，BBU状态回文cliRet4Bbu
# 返 回  值：通过标识flag，错误信息errMsg，回显结果cliRet
#####################################################
def checkBbuNum(cli, flag, errMsg, cliRet4Bbu):
    #modified 2013-12-16 begin
    bbuNumDict = {} 
    #modified 2013-12-16 end
    cliRet4SysInfo = cli.execCmd("show system general")
    cliRet4SysInfoList = cliRet4SysInfo.splitlines()
    lang = py_java_env.get("lang")
    pdtModel = ""
    #能查询到系统信息
    if re.search("System Name", cliRet4SysInfo, re.IGNORECASE):
        #获取产品型号
        for line in cliRet4SysInfoList:
            if re.search("Product Model", line, re.IGNORECASE):
                pdtModel = (line.split(":")[1]).strip()
                break
    else:
        for line in cliRet4SysInfoList:
            #系统没有运行在admin模式
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[BBURemainLife] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet4SysInfo, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[BBURemainLife]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet4SysInfo, errMsg)
            
    #无法获取产品型号
    if "" == pdtModel:
        flag = False
        PY_LOGGER.info("Sequence[BBURemainLife] cannot get product model.")
        if "zh" == lang:
            errMsg += u"\n无法获取产品型号。"
        else:
            errMsg += "\nCannot get product model."
    else:
        #根据产品型号获取标准BBU个数
        standardBbuNum = 0
        #modified 2013-12-16 begin
        bbuNumDict = getBBUNumDict(cli)
        #modified 2013-12-16 end
        if bbuNumDict.has_key(pdtModel):
            standardBbuNum = bbuNumDict[pdtModel]
        
        #未查到标配BBU个数
        if 0 == standardBbuNum:
            flag = False
            PY_LOGGER.info("Sequence[BBURemainLife] The standard configuration number of BBU cannot be found.")
            if "zh" == lang:
                errMsg += u"\n未查到BBU标配个数。"
            else:
                errMsg += "\nThe standard configuration number of BBU cannot be found."
            return (flag, cliRet4SysInfo, errMsg)
        
        #获取真实BBU个数
        cliRet4BbuList = cliRet4Bbu.splitlines()
        count4Bbu = 0
        bbuIdList = []
        isCounterSwitchOn = False
        for line in cliRet4BbuList:
            #如果找到列分隔符"---"，就打开计数开关，并在下一行开始计数
            if re.search("---", line, re.IGNORECASE):
                isCounterSwitchOn = True
                continue
            #如果找到“:/>”，就关闭计数开关，并退出循环
            if re.search(":/>", line, re.IGNORECASE):
                isCounterSwitchOn = False
                break
            #如果是空行，则不计数
            if "" == line.strip():
                continue
            #如果计数开关打开，则开始计数
            if isCounterSwitchOn:
                count4Bbu += 1
                bbuIdList.append(line.split()[0])
        
        #比较真实BBU个数和标配BBU个数是否一致
        change2cli(cli)
        if count4Bbu < standardBbuNum:
            flag = False
            standardBomCode = hardware.getStandardBomCode(bbuIdList,"BBU",cli)
            PY_LOGGER.info("Sequence[BBURemainLife] The number of BBU is not enough.")
            if "zh" == lang:
                errMsg += u"\nBBU个数不足。"
                if standardBomCode: 
                    errMsg += u"\n无法获取信息缺失硬件的BOM编码，正常硬件的BOM编码：（" + standardBomCode + u"）。"
                else:
                    errMsg += u"\n无法获取硬件的BOM编码。"
            else:
                errMsg += "\nThe number of BBU is not enough."
                if standardBomCode:
                    errMsg += u"\nCannot obtain the BOM number of the hardware whose information is missing,BOM number of the normal hardware :" + standardBomCode + u"."
                else:
                    errMsg += u"\nCannot obtain the BOM number of the hardware."
    return (flag, cliRet4SysInfo, errMsg)

#Change to cli model, make sure the next item exec successful
def change2cli(cli):
    index = 0 
    cliRet = cli.execCmdNoLog("show system general")
    
    #密码输入错误时及正常情况从developer模式下退出
    if -1 != cliRet.find("Password") or -1 != cliRet.find("developer:/>"):
        cliRet = cli.execCmd("exit")
        PY_LOGGER.info("Sequence[BBURemainLife] change to cli model")
        while(-1 == cliRet.find(":/>")):
            index += 1
            cliRet = cli.execCmd("exit")
            if -1!=cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = cli.execCmd("n")
            if index > MAX_RETRYS:
                break
        
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    cliRet4Bbu = ""
    cliRet4SysInfo = ""
    try:
        flag = True
        i = 0
        inDeveloper = False
        lang = py_java_env.get("lang")
        errMsg = ""
        
        #切换Developer模式
        flag, errMsg = cliModeManager.changeCli2DeveloperWithErrMsg(cli, py_java_env)
        if not flag:
            return (False, "", errMsg)

        inDeveloper = True

        cliRet4Bbu = cli.execCmd("show bbu life")
        #BBU不在位检查通过 modified 20131122 Begin
        #不能查到BBU寿命信息
        if not (re.search("ID", cliRet4Bbu, re.IGNORECASE) and \
                re.search("Remaining Lifetime", cliRet4Bbu, re.IGNORECASE)):
            cliRet4BbuList = cliRet4Bbu.splitlines()
            for line in cliRet4BbuList:
                #系统不在admin模式
                if line.startswith("-bash") or line.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[BBURemainLife] not in admin mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式。"
                    else:
                        errMsg = "\nSystem is not in admin Mode."
                    return (flag, cliRet4Bbu, errMsg)
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", line, re.IGNORECASE):
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[BBURemainLife]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet4Bbu, errMsg)
                #BBU不在位
                if line.startswith("Command executed successfully."):
                    flag = False
                    PY_LOGGER.info("Sequence[BBURemainLife] BBU does not exist!")
                    if "zh" == lang:
                        errMsg = u"\nBBU不在位。"
                    else:
                        errMsg = "\nBBU does not exist."
                    return (flag, cliRet4Bbu, errMsg)
        else:
            #检测BBU个数是否达标
            retTuple = checkBbuNum(cli, flag, errMsg, cliRet4Bbu)
            flag = retTuple[0]
            cliRet4SysInfo = retTuple[1]
            errMsg = retTuple[2]
            
            #检测BBU寿命
            cliRet4BbuList = cliRet4Bbu.splitlines()
            bbuIDList = []
            except_counter = 0
            for line in cliRet4BbuList:
                i = i + 1
                if i >= 5:
                    list2 = line.split()
                    if len(list2) != 2:
                        continue
                    bbuId = list2[0]
                    bbuIDList.append(bbuId)
            
            if inDeveloper == True:
                try:
                    change2cli(cli)
                    inDeveloper = False
                except:
                    except_counter += 1
            #获取不为空的BBU的BOM编码值
            standardBomCode = hardware.getStandardBomCode(bbuIDList,"BBU",cli)
            i = 0
            for line in cliRet4BbuList:
                i = i + 1
                if i >= 5:
                    list2 = line.split()
                    if len(list2) != 2:
                        continue
                    bbuId = list2[0]
                    if int(list2[1]) < 90:
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\nBBU[" + bbuId + u"]剩余寿命小于90天。"
                            if retTuple[0] == True:
                                if standardBomCode:
                                    errMsg += u"\n硬件（BBU ID：" + bbuId + u"）的BOM编码（" + standardBomCode + u"）。" 
                                else:
                                    errMsg += u"\n无法获取硬件（BBU ID：" + bbuId + u"）的BOM编码。"
                        else:
                            errMsg += "\nThe Remaining Lifetime of BBU[" + bbuId + "] is less than 90 days."
                            if retTuple[0] == True:
                                if standardBomCode:
                                    errMsg += u"\nBOM number of hardware( BBU ID: " + bbuId + u"):" + standardBomCode + u"."
                                else:
                                    errMsg += u"\nCannot obtain the BOM number of the hardware(BBU ID: " + bbuId + u")."
                    
            return (flag, cliRet4Bbu + cliRet4SysInfo, errMsg)
        #BBU不在位检查通过 modified 20131122 End
        #需要优化的检查项  modified 20131125 End
    except Exception, exception:
        PY_LOGGER.error("Sequence[BBURemainLife] catch except of check bbu life.")
        PY_LOGGER.error("Sequence[BBURemainLife] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[BBURemainLife] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[BBURemainLife] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet4Bbu + cliRet4SysInfo, errMsg)
    finally:
        except_counter = 0
        if inDeveloper == True:
            try:
                change2cli(cli)
                inDeveloper = False
            except:
                except_counter += 1
    