# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check BBU version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[BBUVersionConsistency] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[BBUVersionConsistency] execute command result:\n" + unicode(cliRet))

        #Check BBU version
        lines = cliRet.splitlines()
        versionTrace = []
        startFalg = False
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[BBUVersionConsistency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[BBUVersionConsistency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("BBU:"):
                startFalg = True

            if startFalg:
                if - 1 != field.find("----") or - 1 != field.find(" ID "):
                    continue
             
                #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified Begin
                fieldList = field.split()
                if(len(fieldList) == 2):
                    versionTrace.append(fieldList[1])
 
        bbuVersionSort = sorted(list(set(versionTrace)))   
        
        #判断版本是否一致
        if len(bbuVersionSort) > 1:
            flag = False 
            if "zh" == lang:
                errMsg += u"\nBBU版本不一致：" + u'，'.join(bbuVersionSort) + u"。"
            else:
                errMsg += "\nThe version of BBU is different: " + ', '.join(bbuVersionSort) + "."
        #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified End
        
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[BBUVersionConsistency] catch except of check BBU version.")
        PY_LOGGER.error("Sequence[BBUVersionConsistency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[BBUVersionConsistency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[BBUVersionConsistency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)

