# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check BIOS version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[BIOSVersionConsistency] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[BIOSVersionConsistency] execute command result:\n" + unicode(cliRet))

        lines = cliRet.splitlines()
        
        versionTrace = []
        isSwitchOn = False
        for field in lines:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[BIOSVersionConsistency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[BIOSVersionConsistency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified Begin
            #遇到"Controller:"就打开开关
            if re.search("Controller:", field, re.IGNORECASE):
                isSwitchOn = True
            #遇到"Expansion Module:"就关闭开关并退出循环
            if re.search("ExpansionModule:|BBU:", field, re.IGNORECASE):
                isSwitchOn = False
                break
            if isSwitchOn:
                if field.startswith("BIOSVersion:"):
                    versionTrace.append(field.replace("BIOSVersion:", ""))
         
        #大小排序   
        biosVersionSort = sorted(list(set(versionTrace)))
        
        #判断Bios版本是否一致
        if len(biosVersionSort) > 1:
            flag = False 
            if "zh" == lang:
                errMsg += u"\n控制器BIOS版本不一致：" + u'，'.join(biosVersionSort) + u"。"
            else:
                errMsg += "\nThe BIOS version of controller is different: " + u', '.join(biosVersionSort) + "."

        #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified End
            
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[BIOSVersionConsistency] catch except of check BIOS version.")
        PY_LOGGER.error("Sequence[BIOSVersionConsistency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[BIOSVersionConsistency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[BIOSVersionConsistency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
