# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check BMC version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    #S5600T四控BMC版本不一致巡检结果显示通过  modified 20131205 begin
    flag = True
    cliRet = "default"
    errMsg = ""
    lang = "en"
    try:
        lang = py_java_env.get("lang")
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[BMCVersionConsistency] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[BMCVersionConsistency] execute command result:\n" + unicode(cliRet))
        
        cliRetList = cliRet.splitlines()
        ctrlBmcVerList = []
        
        isSwitchOn = False
        for line in cliRetList:
            line = line.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[BMCVersionConsistency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[BMCVersionConsistency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            #遇到"Controller:"就打开开关
            if re.search("Controller:", line, re.IGNORECASE):
                isSwitchOn = True
            #遇到"Expansion Module:"就关闭开关并退出循环
            if re.search("ExpansionModule:|BBU:", line, re.IGNORECASE):
                isSwitchOn = False
                break
            if isSwitchOn:
                if line.startswith("BMCVersion:"):
                    ctrlBmcVerList.append(line.replace("BMCVersion:", ""))
                
        #判断控制器中BMC Version是否一致
        ctrlBmcVerSort = sorted(list(set(ctrlBmcVerList)))
        if len(ctrlBmcVerSort)>1:
            flag = False
            if "zh" == lang:
                errMsg += u"\n控制器中BMC版本不一致：" + u'，'.join(ctrlBmcVerSort)+ u"。"
            else:
                errMsg += "\nThe BMC version of controller is different: " + ', '.join(ctrlBmcVerSort)+"."

        return (flag, cliRet, errMsg)
        #S5600T四控BMC版本不一致巡检结果显示通过  modified 20131205 end
    except Exception, exception:
        PY_LOGGER.error("Sequence[BMCVersionConsistency] catch except of check BMC version.")
        PY_LOGGER.error("Sequence[BMCVersionConsistency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[BMCVersionConsistency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[BMCVersionConsistency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
