# -*- coding: UTF-8 -*-
import traceback
import re
import cliModeManager
MAX_RETRYS = 5


#Change to cli model, make sure the next item exec successful
def change2cli(cli):
    index = 0 
    cliRet = cli.execCmdNoLog("show system general")
    
    #密码输入错误时及正常情况从developer模式下退出
    if - 1 != cliRet.find("Password") or - 1 != cliRet.find("developer:/>"):
        cliRet = cli.execCmd("exit")
        PY_LOGGER.info("Sequence[BSTSwitch] change to cli model")
        while(-1 == cliRet.find(":/>")):
            index += 1
            cliRet = cli.execCmd("exit")
            if - 1 != cliRet.find("Are you sure to exit?(y/n):"):
                cliRet = cli.execCmd("n")
            if index > MAX_RETRYS:
                break
        
def execute(cli):
    """
    Create date        : 2012/05/25
    Function name      : execute(cliConnection)
    Function describe  : check BST switch
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        cliRet = ""
        inDeveloper = False
        lang = py_java_env.get("lang")
        errMsg = ""
        
        #切换Developer模式
        flag, errMsg = cliModeManager.changeCli2DeveloperWithErrMsg(cli, py_java_env)
        if not flag:
            return (False, "", errMsg)
        
        inDeveloper = True

        cliRet = cli.execCmd("show bst configuration")
        
        lines = cliRet.splitlines()
        i = 0
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[BSTSwitch] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[BSTSwitch]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i + 1
            if i > 2:
                field = field.replace(" ", "")
                if field.startswith("Enabled:"):
                    if (field.replace("Enabled:", "") == "Yes") or (field.replace("Enabled:", "") == "No"):
                        flag = True
                        return(flag, cliRet, errMsg)
        
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[BSTSwitch] catch except of check BST switch.")
        PY_LOGGER.error("Sequence[BSTSwitch] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[BSTSwitch] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[BSTSwitch] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
    finally:
        except_counter = 0
        if inDeveloper == True:
            try:
                change2cli(cli)
                inDeveloper = False
            except:
                except_counter += 1
