# -*- coding: UTF-8 -*-
import traceback
import re
G_ITEM_NUM_CONTROLLER = 2


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRetLast = ""
        cliRet = cli.execCmd("show controller general")
        cliRetLast += cliRet
        
        lines = cliRet.splitlines()
        strList = []
        for field in lines:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[BackEndConcurrency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[BackEndConcurrency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
                
            if field.startswith("Controller"):
                temp = field.split(":")
                PY_LOGGER.info("Controller ID is:" + temp[1])
                strList.append(temp[1])
                
        for controllerID in strList:
            cliRet_DirtyRate = ""
            cliRet_DirtyRate = cli.execCmd("show controller io io_type=backEnd controller_id=" + controllerID)
            cliRetLast = cliRetLast + cliRet_DirtyRate
            list2 = cliRet_DirtyRate.splitlines()

            for field in list2:
                field = field.replace(" ", "")

                if field.startswith("-bash") or field.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[BackEndConcurrency] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式。"
                    else:
                        errMsg = "\nSystem is not in admin Mode."
                    return (flag, cliRetLast, errMsg)

                if len(list2) < 5:
                    flag = False
                    PY_LOGGER.info("The backEnd does not query correctly.")
                    if "zh" == lang:
                        errMsg = u"\n未正常查询后端并发数。"
                    else:
                        errMsg = "\nThe Back End IO does not query correctly."
                    return (flag, cliRetLast, errMsg)
                
        return (flag, cliRetLast, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[BackEndConcurrency] catch except of check controller status.")
        PY_LOGGER.error("Sequence[BackEndConcurrency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[BackEndConcurrency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[BackEndConcurrency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
            
        return (flag, cliRetLast, errMsg)
