# -*- coding: UTF-8 -*-
import traceback
import util
import time
import cliModeManager


def cmpErrCodeDict(errCodeDict_1st, errCodeDict_2nd, portType):
    """
    Function name      : cmpErrCodeDict(errCodeDict_1st, errCodeDict_2nd, portType)
    Function describe  : compare error code information
    Input              : errCodeDict_1st, errCodeDict_2nd, portType
    Return             : errMsgList
    """
    errMsgList = []
    lang = py_java_env.get("lang")
    
    PY_LOGGER.info("Sequence[BitErrors]portType is " + unicode(portType))

    portErr_1st = errCodeDict_1st.get(portType + " port")
    portErr_2nd = errCodeDict_2nd.get(portType + " port")

    #没有对应类型的接口卡，不检查
    if not portErr_1st and not portErr_2nd:
        return errMsgList
    
    portErrList_1st = util.formatList(portErr_1st)
    portErrList_2nd = util.formatList(portErr_2nd)
    PY_LOGGER.info("Sequence[BitErrors]portErrList_1st is " + unicode(portErrList_1st))
    PY_LOGGER.info("Sequence[BitErrors]portErrList_2nd is " + unicode(portErrList_2nd))
    
    #检查该接口卡时发生错误，通常是系统繁忙一类
    if not portErrList_1st or not portErrList_2nd:
        if "zh" == lang:
            errMsg = u"获取%s端口信息出错。" % portType
        else:
            errMsg = "There is an error in getting %s port information." % portType
        errMsgList.append(errMsg)
        return errMsgList
    #端口存在
    else:
        portErrDict_1st = {}
        portErrDict_2nd = {}
        for portErrInfo_1st in portErrList_1st:
            if portErrInfo_1st.get("Start Time"):
                del portErrInfo_1st["Start Time"]
            portErrDict_1st[portErrInfo_1st.get("ID")] = portErrInfo_1st
            
        for portErrInfo_2nd in portErrList_2nd:
            if portErrInfo_2nd.get("Start Time"):
                del portErrInfo_2nd["Start Time"]
            portErrDict_2nd[portErrInfo_2nd.get("ID")] = portErrInfo_2nd
                
        #比较两次获取的端口号是否一致
        if portErrDict_1st.keys() != portErrDict_2nd.keys():
            if "zh" == lang:
                errMsg = u"两次获取的%s端口不一致。" % portType
            else:
                errMsg = "%s ports obtained at both times are different." % portType
            errMsgList.append(errMsg)
        else:
            portIds = [portInfo.get("ID") for portInfo in portErrList_1st]
            for key in portIds:
                if portErrDict_1st.get(key) != portErrDict_2nd.get(key):
                    if "zh" == lang:
                        errMsg = u"%s端口[%s]存在持续增加的误码。" % (portType, key)
                    else:
                        errMsg = "Error packets are generated at the system %s port[%s]." % (portType, key)
                    errMsgList.append(errMsg)
                    
        return errMsgList
        
def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = ""
        errMsg = ""
        lang = py_java_env.get("lang")
        
        #切换Developer模式
        flag, errMsg = cliModeManager.changeCli2DeveloperWithErrMsg(cli, py_java_env)
        if not flag:
            return (False, cliRet, errMsg)
        
        #第一次执行命令
        cliRet_1st = cli.execCmd("show port bit_error")
        cliRet += cliRet_1st
        
        time.sleep(60)
        
        #第二次执行命令
        cliRet_2nd = cli.execCmd("show port bit_error")
        cliRet += cliRet_2nd
        
        #如果回显解析结果不是字典格式，说明回显信息有误
        if 'ETH port' not in cliRet_1st or 'ETH port' not in cliRet_2nd:
            flag = False
            if "zh" == lang:
                errMsg = u"\n执行show port bit_error命令失败。"
            else:
                errMsg = "\nFailed to execute command show port bit_error."
            return (flag, cliRet, errMsg)
        
        #解析回显成字典格式
        portErrCodeDict_1st = util.formatDict(cliRet_1st, simpleMode=True)
        portErrCodeDict_2nd = util.formatDict(cliRet_2nd, simpleMode=True)
        PY_LOGGER.info("Sequence[BitErrors] portErrCodeDict_1st is: " + unicode(portErrCodeDict_1st))
        PY_LOGGER.info("Sequence[BitErrors] portErrCodeDict_2nd is: " + unicode(portErrCodeDict_2nd))
        
        #比较五种类型的端口误码信息
        errMsgList = []
        errMsgList += cmpErrCodeDict(portErrCodeDict_1st, portErrCodeDict_2nd, "ETH")
        errMsgList += cmpErrCodeDict(portErrCodeDict_1st, portErrCodeDict_2nd, "FC")
        errMsgList += cmpErrCodeDict(portErrCodeDict_1st, portErrCodeDict_2nd, "FCoE")
        errMsgList += cmpErrCodeDict(portErrCodeDict_1st, portErrCodeDict_2nd, "SAS")
        errMsgList += cmpErrCodeDict(portErrCodeDict_1st, portErrCodeDict_2nd, "PCIE")
        
        #如果存在错误信息，巡检不通过
        if errMsgList:
            flag = False
            errMsg = "\n" + "\n".join(errMsgList)
        
        if not flag:
            PY_LOGGER.info("Sequence[BitErrors] inspect not pass.")
             
        return (flag, cliRet, errMsg)
    
    except:
        PY_LOGGER.error("Sequence[BitErrors] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
    finally:
        cliModeManager.changeAnyModel2Cli(cli)
