# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show controller general")
        ctrlId = ""
        
        lines = cliRet.splitlines()
        for field in lines:
            field = field.replace(" ", "") 
            
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[CPUUsage] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg) 
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[CPUUsage]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:","")
                continue
            
            if field.startswith("CPUUsage"):
                usage = field.split(":")[1]
                PY_LOGGER.info("CPU Usage is: " + usage)
                if int(usage) > 80:
                    flag = False
                    PY_LOGGER.info("CPU Usage is: " + usage)
                    if "zh" == lang:
                        errMsg += u"\n控制器[" + ctrlId + u"]CPU使用率超过80%。"
                    else:
                        errMsg += "\nController[" + ctrlId + "] CPU Usage exceeded 80%."
        return (flag, cliRet, errMsg)
                
    except:
        PY_LOGGER.error("Sequence[CPUUsage] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
