# -*- coding: UTF-8 -*-
import traceback
import util


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check clone general status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show clone general")
        
        #中文回显  modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            cloneID = unicode(formatedDictList[i].get("Clone ID"))
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                PY_LOGGER.info("Sequence[CloneHealthStatus] inspect clone general, healthStatus:" + healthStatus + ", ID:" + cloneID)
                flag = False
                if "zh" == lang:
                    errMsg += u"\n克隆[" + cloneID + u"]状态异常（" + healthStatus + u"）。"
                else:
                    errMsg += "\nThe status of clone[" + cloneID + "] is abnormal(" + healthStatus + ")."
        #中文回显  modify 20140623 end
        
        return (flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[CloneHealthStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
