# -*- coding: UTF-8 -*-
import traceback
import util


def execute(cli):
    """
    Create date        : 2012/08/06
    Function name      : execute(cliConnection)
    Function describe  : check consistency stauts
    Input              : cli--Telnet acess proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show consistency_group general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        #巡检优化 modified 2013-12-10 begin
        for i in range(len(formatedDictList)):
            consistencyGroupID = unicode(formatedDictList[i].get("ID"))
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                PY_LOGGER.info("Sequence[ConsistencyGroupStatus] inspect consistency_group, healthStatus:" + healthStatus + ", ID:" + consistencyGroupID)
                flag = False
                if "zh" == lang:
                    errMsg += u"\n一致性组[" + consistencyGroupID + u"]状态异常（" + healthStatus + u"）。"
                else:
                    errMsg += "\nThe status of consistency group[" + consistencyGroupID + "] is abnormal(" + healthStatus + ")."
        #中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
        #巡检优化 modified 2013-12-10 end
    except:
        PY_LOGGER.error("Sequence[ConsistencyGroupStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
