# -*- coding: UTF-8 -*-
import traceback
import re
import hardware
G_ITEM_NUM_CONTROLLER = 1


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show controller general")
        standardBomCode = hardware.getItemFromELabel(cliRet)
        bomCodeFlag = False
        lines = cliRet.splitlines()
        i, j = 0, 0
        for field in lines:
            field = field.replace(" ", "")
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[ControllerStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[ControllerStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Controller:"):
                ctrlId = field.replace("Controller:", "")
                continue
                        
            if field.startswith("HealthStatus"):
                healthStatus = field.replace("HealthStatus:", "")
                if healthStatus != "Normal":
                    bomCodeFlag = True
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器[" + ctrlId + u"]健康状态异常（" + healthStatus + u"）。"
                        if standardBomCode:
                            errMsg += u"\n硬件（控制器ID：" + ctrlId + u"）的BOM编码（" + standardBomCode + u"）。"
                        else:
                            errMsg += u"\n无法获取硬件（控制器ID：" + ctrlId + u"）的BOM编码。" 
                    else:
                        errMsg += "\nThe health status of Controller [" + ctrlId + "] is abnormal(" + healthStatus + ")."
                        if standardBomCode:
                            errMsg += u"\nBOM number of hardware(Controller ID:" + ctrlId + u"):" + standardBomCode + u"."
                        else:
                            errMsg += u"\nCannot obtain the BOM number of the hardware(Controller ID:" + ctrlId + u") ." 
                i = i + 1
                continue
                
            if field.startswith("RunningStatus"):
                runningStatus = field.replace("RunningStatus:", "")
                if runningStatus != "Online":
                    bomCodeFlag = True
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n控制器[" + ctrlId + u"]运行状态异常（" + runningStatus + u"）。"
                        if standardBomCode:
                            errMsg += u"\n硬件（控制器ID：" + ctrlId + u"）的BOM编码（" + standardBomCode + u"）。"
                        else:
                            errMsg += u"\n无法获取硬件（控制器ID：" + ctrlId + u"）的BOM编码。" 
                    else:
                        errMsg += "\nThe running status of Controller [" + ctrlId + "] is abnormal(" + runningStatus + ")."
                        if standardBomCode:
                            errMsg += u"\nBOM number of hardware(Controller ID:" + ctrlId + u"):" + standardBomCode + u"."
                        else:
                            errMsg += u"\nCannot obtain the BOM number of the hardware(Controller ID:" + ctrlId + u") ." 
                j = j + 1
                continue
        
        #安全模式没有查询到任何控制器信息，Modified 2013/12/09 Begin
        if 0 == i or 0 == j:
            flag = False
            if "zh" == lang:
                errMsg += u"\n系统状态可能不正常，没有查询到任何控制器信息。"
            else:
                errMsg += "\nSystem status may be abnormal, query no controller information."
        #安全模式没有查询到任何控制器信息，Modified 2013/12/09 End
        elif i % 2 == 1 or j % 2 == 1:
            flag = False
            if "zh" == lang:
                errMsg += u"\n可能存在离线的控制器。"
                if bomCodeFlag == False:
                    errMsg += u"\n无法获取信息缺失的硬件的BOM编码，正常硬件的BOM编码（" + standardBomCode + u"）。"
            else:
                errMsg += "\nThe controller of the system may be offline."
                if bomCodeFlag == False:
                    errMsg += "\nCannot obtain the BOM number of the hardware whose information is missing,BOM number of the normal hardware:" + standardBomCode + u") ."

        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[ControllerStatus] catch except of check controller status.")
        PY_LOGGER.error("Sequence[ControllerStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[ControllerStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[ControllerStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
            
        return (flag, cliRet, errMsg)
