# -*- coding: UTF-8 -*-
import traceback
import re

       
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        controller = ""
            
        cliRet = cli.execCmd("show controller general")
        lines = cliRet.splitlines()
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[ControllerTemperature] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[ControllerTemperature]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            field = field.replace(" ","")
            if field.startswith("Controller:"):
                list2 = field.split(":")
                controller = unicode(list2[1])
    
            if field.startswith("AllTemperatures(Celsius)"):
                list2 = field.split(":")
                PY_LOGGER.info("list2[1] is: "+list2[1])
                #modified 2013-12-10 begin
                #Get temperatures of four points: CPU, in, out1, out2
                list3 = unicode(list2[1]).split(",")
                if len(list3) < 2:
                    continue
                strTmprCpu = unicode(list3[0])
                strTmprIn = unicode(list3[1])
                if strTmprCpu.isdigit():
                    tempCPU = int(strTmprCpu)
                    if(tempCPU > 85):
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n控制器[" + controller + u"] CPU温度大于85摄氏度（" + unicode(tempCPU) + u" Celsius）。"
                        else:
                            errMsg += "\nThe CPU temperature of controller[" + controller + u"] is greater than 85 celsius(" + unicode(tempCPU) + " Celsius)."

                if strTmprIn.isdigit():
                    tempIN = int(strTmprIn)
                    if(tempIN >= 52):
                        flag = False
                        if "zh" == lang:
                            errMsg += u"\n控制器[" + controller + u"] 进风口温度大于等于52摄氏度（" + unicode(tempIN) + u" Celsius）。"
                        else:
                            errMsg += "\nThe entrance temperature of controller[ "+ controller + u"] is greater than or equal to 52 celsius(" + unicode(tempIN) + " Celsius)."
                #modified 2013-12-10 end
                
            
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[ControllerTemperature] catch except of check controller temperature.")
        PY_LOGGER.error("Sequence[ControllerTemperature] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[ControllerTemperature] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[ControllerTemperature] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
