# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18 
    Function name      : execute(cliConnection)
    Function describe  : check SN
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = py_java_env.get("showSystemGeneral")
        if None == cliRet:
            cliRet = cli.execCmd("show system general")
            py_java_env.put("showSystemGeneral", cliRet)
        PY_LOGGER.info("\nSequence[DeviceSN] execute command result:\n" + unicode(cliRet))
        
        lines = cliRet.splitlines()
        #Find SN
        for field in lines:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[DeviceSN] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[DeviceSN]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if (1 == field.startswith("SN:")):
                SN = field.replace("SN:", "")
                break

        #Judge the length
        if len("210235G6KDZ0B5000001") == len(SN):
            flag = True
        else :
            PY_LOGGER.info("Sequence[DeviceSN] inspect SN is:" + SN + " Length is:" + unicode(len(SN)))
            if "zh" == lang:
                errMsg = u"\n设备序列号长度错误。"
            else:
                errMsg = "\nThe length of device SN is not correct."
            return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[DeviceSN] catch except of check SN.")
        PY_LOGGER.error("Sequence[DeviceSN] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[DeviceSN] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[DeviceSN] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
