# -*- coding: UTF-8 -*-
import util
import traceback


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show disk_domain general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        #判断回显信息有效性
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        listNormalRunning = ["online", "balancing"]
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            domainID = unicode(formatedDictList[i].get("ID"))
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            runningStatus = unicode(formatedDictList[i].get("Running Status"))
            if "normal" != healthStatus.lower() or runningStatus.lower() not in listNormalRunning:
                PY_LOGGER.info("Sequence[DiskDomain] inspect disk domain, domainID:" + domainID + ", healthStatus:" + healthStatus + ", running status:" + runningStatus)
                flag = False
                if "zh" == lang:
                    errMsg += u"\nDisk domain[" + domainID + u"]状态异常（Health Status：" + healthStatus + u"，Running Status：" + runningStatus + u"）。"
                else:
                    errMsg += "\nThe disk domain[" + domainID + "] status is abnormal(Health Status: " + healthStatus + ", Running Status: " + runningStatus + ")."
        #中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[DiskDomain] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
