# -*- coding: UTF-8 -*-
import traceback
import re
import util


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show disk health")
        
        cmdRetList = cliRet.splitlines()
        #判断回显信息有效性
        if len(cmdRetList) < 5 and not re.search("Disk ID", cliRet, re.IGNORECASE) \
            and not re.search("Health Mark", cliRet, re.IGNORECASE):
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedRet = util.formatStr(cliRet)
        formatedDictList = []
        #如果类型为字典则转换为列表
        if "dict" in unicode(type(formatedRet)):
            formatedDictList.append(formatedRet)
        else:
            formatedDictList = formatedRet
        #硬盘健康度检查修改 modified 20131118 Begin
        for i in range(len(formatedDictList)):
            diskId = unicode(formatedDictList[i].get("Disk ID"))
            healthMask = unicode(formatedDictList[i].get("Health Mark"))
            #硬盘健康度的检查标准不准确, 2013/12/02 Modified Begin
            if healthMask in ["255", "--"]:
                PY_LOGGER.info("Sequence[DiskHealthDegree] diskId [" + diskId + "] Health Mark is:" + healthMask)
                continue
            #硬盘健康度的检查标准不准确, 2013/12/02 Modified End
            
            #健康分值小于等于60，检查不通过
            if not healthMask or not healthMask.isdigit() or int(healthMask) <= 60:
                PY_LOGGER.info("Sequence[DiskHealthDegree] Health Mark is:" + healthMask + "~~~over!")
                flag = False
                if "zh" == lang:
                    errMsg += u"\n硬盘[" + diskId + u"]的健康状态不正常（" + healthMask + u"）。"
                else:
                    errMsg += "\nThe health mark of disk[" + diskId + "] is abnormal(" + healthMask + u")."
        
        return (flag, cliRet, errMsg)
        #硬盘健康度检查修改 modified 20131118 End
    except:
        PY_LOGGER.error("Sequence[DiskHealthDegree] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
            
        return (flag, cliRet, errMsg)
