# -*- coding: UTF-8 -*-

import commonFunction

def execute(cli):
    
    lang = py_java_env.get("lang")
    logger = PY_LOGGER
    cliRet = ""
    errMsg = ""
    bugProductModelList = ['S2600T', 'S5500T', 'S5600T', 'S5800T', 'S6800T']
    bugVersionHead = "V200R002C00"
    
    #检查产品型号
    result, cmdRet, productModel = commonFunction.getProductModel(cli, logger)
    cliRet += cmdRet
    if not result:
        if "zh" == lang:
            errMsg = u"\n查询产品型号失败。"
        else:
            errMsg = u"\nFailed to query the product model."
        return (False, cliRet, "")
    
    if productModel not in bugProductModelList:
        return ("NOSUPPORT", cliRet, "")
    
    #检查产品版本号
    getSucc, sysVerCliRet, currentVersion = commonFunction.getProductFullVersion(cli, logger)
    cliRet += sysVerCliRet
    if not getSucc:
        if "zh" == lang:
            errMsg += u"\n查询系统版本号失败。"
        else:
            errMsg += u"\nFailed to query the system product version."
        return (False, cliRet, errMsg) 
    
    if not currentVersion.startswith(bugVersionHead):
        return (True, cliRet, errMsg)
    
    #检查大于1TB的SAS盘或5TB的NearLine SAS盘，若存在则检查结果checkRet置为False
    result, cmdRet, msgDict, all4kDiskList = commonFunction.get4kDiskInfo(cli, logger)
    cliRet += cmdRet
    if not result or all4kDiskList:
        if "zh" == lang:
            errMsg += msgDict.get("zh")
        else:
            errMsg += msgDict.get("en")
        return (False, cliRet, errMsg)
    
    return (True, cliRet, errMsg)
    
    
    
