# -*- coding: UTF-8 -*-
import traceback
import re
import util
import hardware
import cliCmdManager

def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        allRet = ""
        filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"
        barCodeFilterCmd = "|filterColumn include columnList=ID,Health\\sStatus,Running\\sStatus,Bar\\sCode"
        allRet = cli.execCmd("show disk general")
        cliRet = cli.execCmd("show disk general " + filterCmd)
        barCodecliRet = cli.execCmd("show disk general " + barCodeFilterCmd)
        
        #TV2部分版本过滤命令colunmList字段拼写存在bug，需要兼容
        if not cliCmdManager.hasCliExecPrivilege(barCodecliRet):
            barCodeFilterCmd = "|filterColumn include colunmList=ID,Health\\sStatus,Running\\sStatus,Bar\\sCode"
            barCodecliRet = cli.execCmd("show disk general " + barCodeFilterCmd)
            
        allRet += cliRet
        allRet += barCodecliRet
        lines = cliRet.splitlines()
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[DiskStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, allRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[DiskStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, allRet, errMsg)
       
        diskList = util.formatList(cliRet)
        for diskDict in diskList:
            flag = False
            diskId = diskDict.get("ID")
            healthStatus = diskDict.get("Health Status")
            runningStatus = diskDict.get("Running Status")
            bomCode = hardware.getHorizontalHardwareBomCode(diskId,"DISK",barCodecliRet)
            if "zh" == lang:
                errMsg += u"\n硬盘[%s]状态存在异常（Health Status：%s，Running Status：%s）。" % (diskId, healthStatus, runningStatus)
                if bomCode:
                    errMsg += u"\n硬件（硬盘ID：" + diskId + u"）的BOM编码（" + bomCode + u"）。" 
                else:
                    errMsg += u"\n无法获取硬件（硬盘ID：" + diskId + u"）的BOM编码。"
            
            else:
                errMsg += "\nThe status of disk[%s] is abnormal(Health Status: %s, Running Status: %s)." % (diskId, healthStatus, runningStatus)
                if bomCode:
                    errMsg += u"\nBOM number of hardware(Disk-ID: " + diskId + u"):" + bomCode + u"."
                else:
                    errMsg += u"\nCannot obtain the BOM number of the hardware(Disk-ID: " + diskId + u")."
                        
        return (flag, allRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[DiskStatus] catch except of check disk status.")
        PY_LOGGER.error("Sequence[DiskStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[DiskStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[DiskStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, allRet, errMsg)
