# -*- coding: UTF-8 -*-
import traceback
import re
import util
import hardware


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show enclosure|filterColumn include colunmList=ID,Logic\\sType,Health\\sStatus,Running\\sStatus,SN")
        lines = cliRet.splitlines()
        for field in lines:
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[EnclosureStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[EnclosureStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
        enclosureList = util.formatList(cliRet)
        for enclosureInfo in enclosureList:
            enclosureId = enclosureInfo.get("ID")
            bomCode = hardware.getHorizontalHardwareBomCode(enclosureId,"ENCLOSURE",cliRet)
            logicType = enclosureInfo.get("Logic Type")
            healthStatus = enclosureInfo.get("Health Status")
            runningStatus = enclosureInfo.get("Running Status")
            if logicType != "Data Switch":#不检查交换机
                if healthStatus != "Normal" or runningStatus != "Online":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n框[%s]状态异常（Health Status：%s，Running Status：%s）。" % (enclosureId, healthStatus, runningStatus)
                        if bomCode:
                            errMsg += u"\n硬件（框 ID：" + enclosureId + u"）的BOM编码（" + unicode(bomCode) + u"）。" 
                        else:
                            errMsg += u"\n无法获取硬件（框ID：" + enclosureId + u"）的BOM编码。"
                    else:
                        errMsg += "\nThe status of enclosure[%s] is abnormal(Health Status: %s, Running Status: %s)." % (enclosureId, healthStatus, runningStatus)
                        if bomCode:
                            errMsg += u"\nBOM number of hardware(EnclosureID: " + enclosureId + u"):" + bomCode + u"."
                        else:
                            errMsg += u"\nCannot obtain the BOM number of the hardware(EnclosureID: " + enclosureId + u")."
                        
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[EnclosureStatus] catch except of check enclosure status.")
        PY_LOGGER.error("Sequence[EnclosureStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[EnclosureStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[EnclosureStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
