# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check extent status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = ""
        cliRet1 = ""
        cliRet1 = cli.execCmd("show storage_pool general")

        lines = cliRet1.splitlines()
        i = 0
        for field1 in lines:
            #Need enter to CLI and must in normal mode.
            if field1.startswith("-bash") or field1.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[ExtentMigrationStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet1, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field1, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[ExtentMigrationStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet1, errMsg)
            
            i = i + 1
            if i > 4:
                list1 = field1.split()

                #Find to the end
                if(-1 != list1[0].find(":/>")):
                    break

                #Find right lines and show each POOL_ID
                if(len(list1) >= 6):
                    cliRet2 = cli.execCmd("show storage_pool general pool_id=" + list1[0])
                    cliRet = cliRet + cliRet2
                    listTier = cliRet2.splitlines()
                    #Extent status equal to Ready, relocating and pause
                    for field2 in listTier:
                        extentStatus = "default"
                        field2 = field2.replace(" ", "")
                        if field2.startswith("RelocationStatus:") or field2.startswith("RelocationRunningStatus:"):
                            extentStatus = field2.replace("RelocationStatus:", "").replace("RelocationRunningStatus:", "")
                            if (extentStatus == "Ready") or (extentStatus == "Relocating") or (extentStatus == "Paused"):
                                PY_LOGGER.info("Sequence[ExtentMigrationStatus] check extent status is:" + unicode(extentStatus))
                                break
                            else:
                                flag = False
                                PY_LOGGER.info("Sequence[ExtentMigrationStatus] check extent status is wrong:" + unicode(extentStatus))
                                if "zh" == lang:
                                    errMsg += u"\nPool[" + list1[0] + u"]的迁移状态异常（" + extentStatus + u"）。"
                                else:
                                    errMsg += "\nThe relocation status of pool[" + list1[0] + "] is abnormal(" + extentStatus + ")."
                                break
                            
        return(flag, cliRet1 + cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[ExtentMigrationStatus] catch except of check extent status.")
        PY_LOGGER.error("Sequence[ExtentMigrationStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[ExtentMigrationStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[ExtentMigrationStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet1 + cliRet, errMsg)
