# -*- coding: UTF-8 -*-
import traceback
import util


# **************************************************************************** #
# 函数名称: checkFcPorts
# 功能说明: 判断FC端口是否巡检通过
# 输入参数: cli
# 输出参数: True or False
# **************************************************************************** # 
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show port general physical_type=FC")
        
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                #包含不存在的情况
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatList(cliRet)
        for dictFCPort in formatedDictList:
            if dictFCPort.get("Health Status") != "Normal":
                flag = False
                if "zh" == lang:
                    errMsg += u"\nFC端口[" + dictFCPort.get("ID") + u"]健康状态异常（" + dictFCPort.get("Health Status") + u"）。"
                else:
                    errMsg += "\nThe health status of FC port [" + dictFCPort.get("ID") + "] is abnormal(" + dictFCPort.get("Health Status") + ")." 
                continue
            elif dictFCPort.get("Running Status") == "Link Up" or dictFCPort.get("Running Status") == "Running":
                if dictFCPort.get("Working Rate(Mbps)") not in ["2000", "4000", "8000", "16000"]:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nFC端口[" + dictFCPort.get("ID") + u"]速率异常（" + dictFCPort.get("Working Rate(Mbps)") + u"Mbps）。"
                    else:
                        errMsg += "\nThe speed of FC port[" + dictFCPort.get("ID") + "] is abnormal(" + dictFCPort.get("Working Rate(Mbps)") + "Mbps)."
                    continue
            elif dictFCPort.get("Running Status") == "Link Down":
                continue
            else:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nFC端口[" + dictFCPort.get("ID") + u"]运行状态异常（" + dictFCPort.get("Running Status") + u"）。"
                else:
                    errMsg += "\nThe running status of FC port[" + dictFCPort.get("ID") + "] is abnormal(" + dictFCPort.get("Running Status") + ")."
                continue
                
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[FC] catch except of when checking FC port.")
        PY_LOGGER.error("Sequence[FC] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[FC] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[FC] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)