# -*- coding: UTF-8 -*-
import traceback
import re
import util
import hardware

#需要优化的检查项  modified 20131125 Begin
################################################################
# 函数名称：getEnclosureList
# 功能说明：获取框（或者PCIE交换机）列表
# 传入参数：查看框（或者PCIE交换机）的cli回文cliRet4Enclosure，语言lang
# 返  回  值：框（或者PCIE交换机）列表，通过标识flag，错误信息errMsg
################################################################
def getEnclosureList(cliRet4Enclosure, lang):
    flag = True
    errMsg = ""
    enclosureList = []
    #能够查询到框（或者PCIE交换机）信息
    if re.search("ID", cliRet4Enclosure, re.IGNORECASE) and re.search("Health", cliRet4Enclosure, re.IGNORECASE):
        cliRet4EnclosureList = cliRet4Enclosure.splitlines()
        isSwitchOn = False
        for line in cliRet4EnclosureList:
            #找到"---"后打开开关，并在下一行开始
            if re.search("---", line, re.IGNORECASE):
                isSwitchOn = True
                continue
            #找到":/>"则退出
            if re.search(":/>", line, re.IGNORECASE):
                break
            #如果是空行，则继续
            if "" == line.strip():
                continue
            #开关打开，表示有效行（即在"---"和":/>"之间的非空白行）
            if isSwitchOn:
                enclosureList.append(line.strip().split()[0])
        return (enclosureList, flag, errMsg)
    else:
        cliRet4EnclosureList = cliRet4Enclosure.splitlines()
        for line in cliRet4EnclosureList:
            #系统没有运行在admin模式
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[FanStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (enclosureList, flag, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[FanStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                PY_LOGGER.info(enclosureList, flag, errMsg)
        #可能产生的其它错误信息
        flag = False
        PY_LOGGER.info("There is an error in Sequence[FanStatus]!")
        if "zh" == lang:
            errMsg = u"\n获取信息出错。"
        else:
            errMsg = "\nThere is an error in getting information."
        return (enclosureList, flag, errMsg)

########################################################################
# 函数名称：checkFanNumAndStatus
# 功能说明：检查风扇个数和状态是否达标
# 传入参数：风扇cli回文cliRet4Fan，框（或者PCIE交换机）列表enclosureList，语言lang
# 返 回  值：通过标识flag，错误信息errMsg
########################################################################
def checkFanNumAndStatus(cliRet4Fan, enclosureList, lang ,cli):
    flag = True
    errMsg = ""
    enclosureId = ""
    hardwareType = "FAN"
    standardBomCode = ""
    BomCodeFlag = "False"
    enclosureIdDict = {}
    
    #初始化框（或者PCIE交换机）ID字典
    for enclosure in enclosureList:
        enclosureIdDict[enclosure] = 0
    
    #能够查询到数据
    if re.search("ID", cliRet4Fan, re.IGNORECASE) and re.search("Health", cliRet4Fan, re.IGNORECASE):
        
        fanList = util.formatList(cliRet4Fan)
        fanIdlist = []
        for fanDetail in  fanList:
            fanID = fanDetail.get("ID")
            fanIdlist.append(fanID)
        itemList = hardware.getHardwareItemList(fanIdlist,hardwareType,cli)
        for fanDetail in  fanList:
            fanID = fanDetail.get("ID") 
            enclosureId = fanID.split(".")[0]
            standardBomCode = hardware.getFANBomCodeByEncId(enclosureId,fanIdlist,itemList)
            #记录框中风扇的数量
            enclosureIdDict[enclosureId] = enclosureIdDict.get(enclosureId, 0) + 1
            
            healthStatus = fanDetail.get("Health Status")
            runningStatus = fanDetail.get("Running Status")
            
            if healthStatus != "Normal" or runningStatus != "Running":
                flag = False
                if "zh" == lang:  
                    errMsg += u"\n风扇[%s]状态异常（Health Status：%s，Running Status：%s）。" % (fanID, healthStatus, runningStatus)
                    if standardBomCode:
                        errMsg += u"\n硬件（风扇ID：" + fanID\
                                      + u"）的BOM编码（" + standardBomCode + u"）。"  
                    else:
                        errMsg += u"\n无法获取硬件（风扇ID：" + fanID\
                              + u"）的BOM编码。" 
                else:
                    errMsg += "\nThe status of fan[%s] is abnormal(Health Status: %s, Running Status: %s)." % (fanID, healthStatus, runningStatus)
                    if standardBomCode:
                                errMsg += u"\nBOM number of hardware(fan-id:" + fanID\
                                      + u"):" + standardBomCode + u"."  
                    else:
                        errMsg += u"\nCannot obtain the BOM number of the hardware(fan-id:" + fanID\
                              + u")." 
                PY_LOGGER.info("\nSequence[FanStatus] inspect not pass.")
            
        #判断风扇个数是否达标：每个框（或PCIE）的风扇个数大于等于2为达标
        for enclosure in enclosureList:
            if int(enclosureIdDict.get(enclosure)) < 2:
                standardBomCode = hardware.getFANBomCodeByEncId(enclosure,fanIdlist,itemList) 
                flag = False
                PY_LOGGER.info("Sequence[FanStatus] the number of fan is not enough")
                if "zh" == lang:
                    errMsg += u"\n框[" + enclosure + u"]的风扇数量不足。"
                    if standardBomCode:
                        errMsg += u"\n框[" + enclosure + u"]的风扇BOM编码（" + standardBomCode + u"）。"  
                    else:
                        errMsg += u"\n无法获取框[" + enclosure + u"]的风扇BOM编码。" 
                else:
                    errMsg += "\nThe number of fan in enclosure[" + enclosure + "] is not enough."
                    if standardBomCode:
                        errMsg += u"\nBOM number of fan in enclosure[" + enclosure + "]:" + standardBomCode + u"."  
                    else:
                        errMsg += u"\nCannot obtain the BOM number of fan in enclosure[" + enclosure + "]." 
        return (flag, errMsg)
    
    #回文结果异常分支
    else:
        cliRet4FanList = cliRet4Fan.splitlines()
        for line in cliRet4FanList:
            #系统没有运行在admin模式
            if line.startswith("-bash") or line.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[FanStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", line, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[FanStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, errMsg)
            #风扇不在位
            if line.startswith("Command executed successfully."):
                flag = False
                PY_LOGGER.info("Sequence[FanStatus] fan is not on the place!")
                if "zh" == lang:
                    errMsg = u"\n风扇不在位。"
                else:
                    errMsg = "\nFan does not exist."
                return (flag, errMsg)
        #可能产生的其它错误信息
        flag = False
        PY_LOGGER.info("There is an error in Sequence[FanStatus]!")
        if "zh" == lang:
            errMsg = u"\n获取信息出错。"
        else:
            errMsg = "\nThere is an error in getting information."
        return (flag, errMsg)

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    flag = True
    cliRet = ""
    errMsg = ""
    lang = "en" #语言默认值设为英文
    hardwareType = "FAN"
    try:
        lang = py_java_env.get("lang")
        
        #获取框（或者PCIE交换机）回文
        cliRet4Enclosure = cli.execCmd("show enclosure")
        
        #获取框ID信息
        enclosureInfoTuple = getEnclosureList(cliRet4Enclosure, lang)
        enclosureList = enclosureInfoTuple[0]
        flag4Enclosure = enclosureInfoTuple[1]
        errMsg4Enclosure = enclosureInfoTuple[2]
        #无法查询到框（或者PCIE交换机）信息，则直接返回
        if 0 == len(enclosureList):
            return (flag4Enclosure, cliRet4Enclosure, errMsg4Enclosure)
        
        #获取风扇状态回文
        cliRet4Fan = cli.execCmd("show fan")
        #检查风扇个数和状态是否达标
        fanNumAndStatusCheckRetTuple = checkFanNumAndStatus(cliRet4Fan, enclosureList, lang, cli)
        flag4FanNumAndStatusCheck = fanNumAndStatusCheckRetTuple[0]
        errMsg4FanNumAndStatusCheck = fanNumAndStatusCheckRetTuple[1]
        
        #返回结果
        flag = flag4Enclosure and flag4FanNumAndStatusCheck
        cliRet = cliRet4Enclosure + cliRet4Fan
        errMsg = errMsg4Enclosure + errMsg4FanNumAndStatusCheck
        return (flag, cliRet, errMsg)
        
        #需要优化的检查项  modified 20131125 End
    except Exception, exception:
        PY_LOGGER.error("Sequence[FanStatus] catch except of check fan status.")
        PY_LOGGER.error("Sequence[FanStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[FanStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[FanStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
