# -*- coding: UTF-8 -*-
import traceback
import re
import hardware

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    lang = py_java_env.get("lang")
    cliRet = ""
    try:
        flag = True
        errMsg = ""
        cliRet = cli.execCmd("show port fibre_module|filterColumn include colunmList=PortID,Health\sStatus,Model")
        if "^" in cliRet:
            cliRet = cli.execCmd("show port fibre_module|filterColumn include columnList=PortID,Health\sStatus,Model")     
        lines = cliRet.splitlines()
        i = 0
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[FibreModule] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[FibreModule]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            i = i + 1
            if i >= 5:
                list2 = field.split()
                if - 1 != field.find(":/>") or field.startswith("developer:/>"):
                    PY_LOGGER.info("Sequence[FibreModule] field is:" + unicode(field))
                    continue
                portId = list2[0]
                bomCode = hardware.getHorizontalHardwareBomCode(portId,"FIBRE",cliRet)
                if list2[1] != "Normal":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n端口[" + portId + u"]状态异常（" + list2[1] + u"）。"
                        if bomCode:
                            errMsg += u"\n硬件（端口ID：" + portId + u"）的BOM编码（" + bomCode + u"）。" 
                        else:
                            errMsg += u"\n无法获取硬件（端口ID：" + portId + u"）的BOM编码。"
            
                    else:
                        errMsg += "\nThe status of port[" + portId + "] is abnormal(" + list2[1] + ")."
                        if bomCode:
                            errMsg += u"\nBOM number of hardware(Port-ID: " + portId + u"):" + bomCode + u"."
                        else:
                            errMsg += u"\nCannot obtain the BOM number of the hardware(Port-ID: " + portId + u")."
                     
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[FibreModule] catch except of check fibre module.")
        PY_LOGGER.error("Sequence[FibreModule] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[FibreModule] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[FibreModule] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
