# -*- coding: UTF-8 -*-
import traceback
import re
G_ITEM_NUM_CONTROLLER = 2


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = ""
        cliRet = cli.execCmd("show controller general")
        
        lines = cliRet.splitlines()
        strList = []
        for field in lines:
            field = field.replace(" ", "")
            
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[FrontEndConcurrency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[FrontEndConcurrency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)    
            
            if field.startswith("Controller"):
                temp = field.split(":")
                strList.append(temp[1])
                
        for controllerID in strList:
            cliRet_DirtyRate = ""
            cliRet_DirtyRate = cli.execCmd("show controller io io_type=frontEnd " + "controller_id=" + controllerID)
            cliRet += cliRet_DirtyRate
            list2 = cliRet_DirtyRate.splitlines()

            for field in list2:
                field = field.replace(" ", "")

                if field.startswith("-bash") or field.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[FrontEndConcurrency] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式。"
                    else:
                        errMsg = "\nSystem is not in admin Mode."
                    return (flag, cliRet, errMsg)

                if len(list2) < 4:
                    flag = False
                    PY_LOGGER.info("The frontEnd is not find right.")
                    if "zh" == lang:
                        errMsg = u"\n未正常查询前端并发数。"
                    else:
                        errMsg = "\nThe Front End IO does not query correctly."
                    return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[FrontEndConcurrency] catch except of check controller status.")
        PY_LOGGER.error("Sequence[FrontEndConcurrency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[FrontEndConcurrency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[FrontEndConcurrency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
            
        return (flag, cliRet, errMsg)
