# -*- coding: UTF-8 -*-
import re
import xlrd
import os
import util


'''由于Python库xlrd的局限性，目前只支持解析Excel_2003的文件'''
HITACHI_DISK_FILE_NAME = r'HitachiRiskDisk_Huawei.xls'

def execute(cli):
    '''
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : flag, cliRet, errMsg
    '''
    
    flag = True
    cliRet = ''
    errMsg = ''
    lang = py_java_env.get("lang")

    #从excel中读取风险盘的SN
    hitachiRiskDiskSNList = getDiskSNList()
    
    itemCliRet = cli.execCmd('show disk general')
    cliRet += itemCliRet
    
    #检查硬盘状态
    itemCliRet = cli.execCmd('show disk general'
                         + ' |filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal'
                         + ' logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online'
                         + ' logicOp=or column=Model predict=equal_to value=HUC109030CSS600'
                         + ' logicOp=or column=Model predict=equal_to value=HUC109060CSS600')
    
    cliRet += itemCliRet
    if not util.checkCliInfoValid(itemCliRet, False):

        if lang == "zh":
            errMsg = u"\n无效CLI信息。"
        else:
            errMsg = "\nInvalid Cli information."
        return (False, cliRet, errMsg)
       
    diskInfoList = util.formatList(itemCliRet)
    
    #如果没有查到硬盘信息，说明不存在状态不正常的硬盘以及可能是日立风险盘的硬盘
    if not diskInfoList:
        return (True, cliRet, errMsg)
    
    diskCount = 0
    hitachiRiskDiskIDList = []
    for diskInfo in diskInfoList:
        diskId = diskInfo.get('ID')
        healthStatus = diskInfo.get('Health Status')
        runningStatus = diskInfo.get('Running Status')
        
        #检查硬盘状态
        if healthStatus != "Normal" or runningStatus != "Online":
            flag = False
            if lang == "zh":
                errMsg += u"\n硬盘[%s]状态异常（Health Status：%s，Running Status：%s）。" % (diskId, healthStatus, runningStatus)
            else:
                errMsg += "\nThe status of disk[%s] is abnormal(Health Status: %s, Running Status: %s)." % (diskId, healthStatus, runningStatus)
            continue
            
        itemCliRet = cli.execCmd('show disk general disk_id=' + diskId)
        
        if not util.checkCliInfoValid(itemCliRet, False):
            #控制回显信息数量
            if diskCount < 10:
                cliRet += itemCliRet
                diskCount += 1
            flag = False
            if lang == "zh":
                errMsg += u"\n查询硬盘[%s]详细信息失败。" % (diskId,)
            else:
                errMsg += "\nFailed to query the detail information of disk[%s]." % (diskId,)
            continue
    
        #收集日立风险盘    
        diskDetail = util.formatDict(itemCliRet)
        if type(diskDetail) == dict and diskDetail.get('Serial Number') in hitachiRiskDiskSNList:
            hitachiRiskDiskIDList.append(diskId)
            #控制回显信息数量
            if diskCount < 10:
                cliRet += itemCliRet
                diskCount += 1
        else:
            continue
        
    
    if hitachiRiskDiskIDList:
        flag = False
        if lang == "zh":
            errMsg += u"\n设备中存在日立风险盘：" + u'，'.join(hitachiRiskDiskIDList) + u"。"
        else:
            errMsg += "\nThe Device exist HITACHI risk disks: " + ', '.join(hitachiRiskDiskIDList) + "."
    
    return (flag, cliRet, errMsg)

    
def getDiskSNList():
    '''
    Function name      : getDiskList()
    Function describe  : get compass Disk List.
    Return             : compass Disk series Number List
    '''
    
    excel = Excel()
    excel.open()
    seriesNoList = excel.creatHitachiRiskDiskSNList(['600G', '300G'], 0)

    return seriesNoList

class Excel(object):
    '''
    Class name          : Excel
    Class describe      : interface to read Excel file
    '''
    
    def __init__(self, filename=HITACHI_DISK_FILE_NAME):
        '''
        Function name      : __init__(filename)
        Function describe  : initialize Class 
        '''
        
        '''将当前路径插入到文件名前'''
        filepath = py_java_env.get('path')
        filename = filepath + os.sep + filename
        self.filename = filename

    def open(self):
        '''
        Function name      : open()
        Function describe  : Open excel file and active sheet
        '''
        
        self.dada = xlrd.open_workbook(self.filename)

    def creatHitachiRiskDiskSNList(self, sheet_name_list, start_row):
        '''
        Function name      : creatCompassDiskList(sheet_name_list, start_row)
        Function describe  : get compass disk list from excel file
        Input              : sheet_name_list--sheet name List
                             start_row --the row number that start to read
        Return             : compass disk list
        '''
        seriesNoList = []
        for sheet_name in sheet_name_list:
            self.table = self.dada.sheet_by_name(sheet_name)
            nrows = self.table.nrows
            
            for rownum in range(start_row, nrows, 1):
                cell = unicode(self.table.cell(rownum, 0))
    
                if re.search('empty', cell, re.IGNORECASE):
                    continue
                elif re.search('HDDSN', cell, re.IGNORECASE):
                    continue
                else:
                    driveSeriesNo = cell.replace('text:u', '').replace('\'', '')
                    seriesNoList.append(driveSeriesNo)

        return seriesNoList
