# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute warning alarm check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        send_alarm = True
        #主机多路径状态检查告警ID modified 20131120 begin
        alarmID = [
         "0xF00150019",
         "0xF0015001A",
         "0xF0015001B",
         "0x100F0015001C",
         "0xF0015001D"]
        errMsg = ""
        cliRet4Return = ""

        for element in alarmID:
            cliRet = ""
            send_alarm = True
            cliRet = cli.execCmd("show alarm |filterRow column=ID predict=equal_to value=" + element)
            cliRet4Return += cliRet
            lines = cliRet.splitlines()
            for field in lines:
                #Need enter to CLI and must in normal mode.
                if field.startswith("-bash") or field.startswith("upgrade"):
                    flag = False
                    PY_LOGGER.info("Sequence[HostMultipathStatus] not in CLI mode, out!")
                    if "zh" == lang:
                        errMsg = u"\n系统没有运行在admin模式。"
                    else:
                        errMsg = "\nSystem is not in admin Mode."
                    return (flag, cliRet, errMsg)
                #其它出现“Error:”字眼的信息视为不通过
                if re.search("Error:", field, re.IGNORECASE):
                    flag = False
                    PY_LOGGER.info("There is an error in Sequence[HostMultipathStatus]!")
                    if "zh" == lang:
                        errMsg = u"\n获取信息出错。"
                    else:
                        errMsg = "\nThere is an error in getting information."
                    return (flag, cliRet, errMsg)
                
                if field.find("Command executed successfully") != -1:
                    send_alarm = False
                else:
                    continue
                
            if send_alarm == True:
                flag = False
                if "zh" == lang:
                    errMsg += u"\n产生的告警ID为： " + element + u"。"
                else:
                    errMsg += "\nThe ID of the alarm is: " + element + "."
        return (flag, cliRet4Return, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[HostMultipathStatus] catch except of check warning alarm.")
        PY_LOGGER.error("Sequence[HostMultipathStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[HostMultipathStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[HostMultipathStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet4Return, errMsg)
        #主机多路径状态检查告警ID modified 20131120 end
