# -*- coding: UTF-8 -*-
import traceback
import re
import util


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check hotspare spaces
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show disk_domain general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        for i in range(len(formatedDictList)):
            diskDomainID = unicode(formatedDictList[i].get("ID"))
            usedHotSpareCap = unicode(formatedDictList[i].get("Used Hot Spare Capacity"))
            #巡检优化 modified 2013-12-10 begin
            if usedHotSpareCap != "0.000B":
                flagItem, flagTemp, cliRetItem, errMsgItem = checkDiskStatus(cli, diskDomainID, py_java_env)
                if not flagTemp:
                    return (flagTemp, cliRet+cliRetItem, errMsgItem)
                
                if not flagItem:
                    PY_LOGGER.info("Sequence[HotSpareCapacity] inspect Used Hot Spare Capacity:" + usedHotSpareCap)
                    cliRet += "\n" + cliRetItem 
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nDomain[" + diskDomainID + u"]的Used Hot Spare Capacity不为0。"
                    else:
                        errMsg += "\nThe Used Hot Spare Capacity in domain[" + diskDomainID + "] is not 0."
        #中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
        #巡检优化 modified 2013-12-10 end
    except:
        PY_LOGGER.error("Sequence[HotSpareCapacity] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
    
# **************************************************************************** #
# 函数名称: checkDiskStatus
# 功能说明: 检查disk_domain下的硬盘状态是否正常
# 输入参数: cli，diskdomain
# 输出参数: 无
# 返 回 值: flag, flagErr, cliRet, errMsg
# **************************************************************************** # 
def checkDiskStatus(cli, diskdomain, py_java_env):   
    flag = True
    flagErr = True
    cliRet = ""
    lang = py_java_env.get("lang")
    errMsg = ""
    filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"        
    cliRet = cli.execCmd("show disk in_domain disk_domain_id=" + unicode(diskdomain) + filterCmd)
    
    lines = cliRet.splitlines()
    i = 0
    for field in lines:
        if field.startswith("-bash") or field.startswith("upgrade"):
            flagErr = False
            if "zh" == lang:
                errMsg = u"\n系统没有运行在admin模式。"
            else:
                errMsg = "\nSystem is not in admin Mode."
            return (flag, flagErr, cliRet, errMsg)
 
        if re.search("Error:", field, re.IGNORECASE):
            flagErr = False
            if "zh" == lang:
                errMsg = u"\n获取信息出错"
            else:
                errMsg = "\nThere is an error in getting information."
            return (flag, flagErr, cliRet, errMsg)
        
        i = i+1    
        if i > 3:
            flag = False
            return (flag, flagErr, cliRet, errMsg)
        
    return (flag, flagErr, cliRet, errMsg)