# -*- coding: UTF-8 -*-
import util
import traceback
import hardware


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = ""
        cliRet = cli.execCmd("show interface_module")
        lines = cliRet.splitlines()
        if len(lines) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                flag = True       
            return (flag, cliRet, errMsg)  
        
        StatusList = util.formatStr(cliRet)
        idList = []
        for i in range(len(StatusList)):  
            InterfaceID = StatusList[i].get("ID")
            idList.append(InterfaceID)
        
        # 存放接口卡的BomCode
        BomCode = ""           
        for i in range(len(StatusList)):  
            InterfaceID = StatusList[i].get("ID")
            checkCmd = "show interface_module interface_module_id=" + InterfaceID 
            
            detailCliRet = cli.execCmd(checkCmd)
            cliRet += detailCliRet
            BomCode = hardware.getItemFromELabel(cliRet)   
            HealthStatus = StatusList[i].get("Health Status")
            RunningStatus = StatusList[i].get("Running Status")    
            if "normal" != HealthStatus.lower() or "running" != RunningStatus.lower():
                flag = False
                if "zh" == lang:
                    errMsg += u"\n接口卡[" + InterfaceID + u"]状态异常（Health Status：" + HealthStatus + u"，Running Status：" + RunningStatus + u"）。"
                    if BomCode:
                        errMsg += u"\n硬件（接口卡ID：" + InterfaceID + u"）的BOM编码（" + BomCode + u"）。" 
                    else:
                        errMsg += u"\n无法获取硬件（接口卡ID：" + InterfaceID + u"）的BOM编码。"
                else:
                    errMsg += "\nThe interface module[" + InterfaceID + "] runs abnormally(Health Status: " + HealthStatus + ", Running Status: " + RunningStatus + ")."
                    if BomCode:
                        errMsg += u"\nBOM number of hardware(InterfaceID: " + InterfaceID + u"):" + BomCode + u"."
                    else:
                        errMsg += u"\nCannot obtain the BOM number of the hardware(InterfaceID: " + InterfaceID + u")."
        return (flag, cliRet, errMsg)
    
    except Exception, exception:
        flag = False 
        PY_LOGGER.error("Sequence[InterfaceModule] catch except of check InterFace Module.")
        PY_LOGGER.error("Sequence[InterfaceModule] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[InterfaceModule] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[InterfaceModule] catch except of trace back:" + unicode(traceback.print_exc()))
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
