# -*- coding: UTF-8 -*-
import traceback
import util


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check lun_copy general status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show lun_copy general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"无效CLI信息。"
                else:
                    errMsg = "Invalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatStr(cliRet)
        #LUN拷贝健康状况检查结果不通过时描述不准确  modified 20131109 begin
        for i in range(len(formatedDictList)):
            lunCopyID = unicode(formatedDictList[i].get("ID"))
            #Lun_Copy中运行状态为completed modified 20131128 begin
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            if "normal" != healthStatus.lower():
                PY_LOGGER.info("Sequence[LUNCopyHealthStatus] inspect Lun_copy general, healthStatus:" + healthStatus + ", ID:" + lunCopyID)
                flag = False
                if "zh" == lang:
                    errMsg += u"\nLUN拷贝[" + lunCopyID + u"]状态异常（" + healthStatus + u"）。"
                else:
                    errMsg += "\nThe status of LUN copy[" + lunCopyID + "] is abnormal(" + healthStatus + ")."
            #Lun_Copy中运行状态为completed modified 20131128 end
        #中文回显 modify 20140623 end
        
        return (flag, cliRet, errMsg)
        #LUN拷贝健康状况检查结果不通过时描述不准确  modified 20131109 end
    except:
        PY_LOGGER.error("Sequence[LUNCopyHealthStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
