# -*- coding: UTF-8 -*-
import traceback
import re
import util


def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        allRet = ""
        #Optimize check rate, use filter
        filterCmd = "|filterRow column=Health\sStatus predict=not predict2=equal_to value=Normal logicOp=or column=Running\sStatus predict=not predict2=equal_to value=Online"
        allRet = cli.execCmd("show lun general")
        cliRet = cli.execCmd("show lun general " + filterCmd)
        allRet += cliRet

        
        lines = cliRet.splitlines()
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[LUNStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, allRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[LUNStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, allRet, errMsg)
            
        lunList = util.formatList(cliRet)
        for lunDetail in lunList:
            lunID = lunDetail.get("ID")
            healthStatus = lunDetail.get("Health Status")
            runningStatus = lunDetail.get("Running Status")
            if healthStatus != "Normal" or runningStatus != "Online":
                flag = False
                if "zh" == lang:
                    errMsg += u"\nLUN[%s]状态异常（Health Status：%s，Running Status：%s）。" % (lunID, healthStatus, runningStatus)
                else:
                    errMsg += u"\nThe status of LUN[%s] is abnormal(Health Status: %s, Running Status: %s)." % (lunID, healthStatus, runningStatus)
            
        return (flag, allRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[LUNStatus] catch except of check LUN status.")
        PY_LOGGER.error("Sequence[LUNStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[LUNStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[LUNStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = u"\nQuery result is abnormal."
        return (flag, allRet, errMsg)
