# -*- coding: UTF-8 -*-
import traceback
import re
import util


def execute(cli):
    """
    Create date        : 2012/05/18, Midify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : check LUN write policy
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet1 = ""
        cliRet2 = ""
        allCliRet = ""
        cliRetLUNInfo = ""
        filterCmd1 = "|filterRow column=Write\sPolicy predict=equal_to value=Write\sBack logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=Write\sBack"
        filterCmd2 = "|filterRow column=Write\sPolicy predict=equal_to value=Write\sThrough logicOp=and column=Running\sWrite\sPolicy predict=not predict2=equal_to value=Write\sThrough"
        
        cliRetLUNInfo = cli.execCmd("show lun general")
        cliRet1 = cli.execCmd("show lun general " + filterCmd1)
        allCliRet = cliRetLUNInfo + cliRet1
        
        listCliRet1 = cliRet1.splitlines()
        for field in listCliRet1:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[LUNWritePolicy] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, allCliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[LUNWritePolicy]!")
                if "zh" == lang:
                    errMsg = u"\n获取LUN信息出错。"
                else:
                    errMsg = "\nThere is an error in getting LUN information."
                return (flag, allCliRet, errMsg)
        
        count1LimitInfo = 0
        lunDictListBack = util.formatList(cliRet1)
        for lunDict in lunDictListBack:
            lunID = lunDict.get("ID")
            cliRetLUN = cli.execCmd("show lun general lun_id=" + lunID)
            #对LUN具体信息做限制10个
            if count1LimitInfo < 10:
                count1LimitInfo += 1
                allCliRet += cliRetLUN
            #命令执行失败报提示，继续后面的LUN
            if not util.checkCliInfoValid(cliRetLUN, True):
                flag = False
                if "zh" == lang:
                    errMsg += u"\n命令:show lun general lun_id=" + lunID + u"执行失败。"
                else:
                    errMsg += u"\nFailed to execute the command: show lun general lun_id=" + lunID + u"."
                continue
            #命令执行成功进行解析
            lunInfoDict = util.formatDict(cliRetLUN)
            writePolicy = lunInfoDict.get("Write Policy")
            runningWritePolicy = lunInfoDict.get("Running Write Policy")
            if writePolicy != runningWritePolicy:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nLUN[%s]的写策略与运行写策略不一致（Write Policy：%s，Running Write Policy：%s）。" % (lunID, writePolicy, runningWritePolicy)
                else:
                    errMsg += u"\nThe write policy of LUN[%s] is not consistent with running write policy(Write Policy: %s, Running Write Policy: %s)." % (lunID, writePolicy, runningWritePolicy)
                continue
            
        #另一个命令开始解析
        cliRet2 = cli.execCmd("show lun general " + filterCmd2)
        allCliRet += cliRet2
        listCliRet2 = cliRet2.splitlines()
        for field in listCliRet2:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[LUNWritePolicy] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, allCliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[LUNWritePolicy]!")
                if "zh" == lang:
                    errMsg = u"\n获取LUN信息出错。"
                else:
                    errMsg = "\nThere is an error in getting LUN information."
                return (flag, allCliRet, errMsg)
        
        count2LimitInfo = 0
        lunDictListThrough = util.formatList(cliRet2)
        for lunDict in lunDictListThrough:
            lunID = lunDict.get("ID")
            cliRetLUN = cli.execCmd("show lun general lun_id=" + lunID)
            #对LUN具体信息做限制10个
            if count2LimitInfo < 10:
                count2LimitInfo += 1
                allCliRet += cliRetLUN
            #命令执行失败报提示，继续后面的LUN
            if not util.checkCliInfoValid(cliRetLUN, True):
                flag = False
                if "zh" == lang:
                    errMsg += u"\n命令:show lun general lun_id=" + lunID + u"执行失败。"
                else:
                    errMsg += u"\nFailed to execute the command: show lun general lun_id=" + lunID + u"."
                continue
            #命令执行成功进行解析
            lunInfoDict = util.formatDict(cliRetLUN)
            writePolicy = lunInfoDict.get("Write Policy")
            runningWritePolicy = lunInfoDict.get("Running Write Policy")
            if writePolicy != runningWritePolicy:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nLUN[%s]的写策略与运行写策略不一致（Write Policy：%s，Running Write Policy：%s）。" % (lunID, writePolicy, runningWritePolicy)
                else:
                    errMsg += u"\nThe write policy of LUN[%s] is not consistent with running write policy(Write Policy: %s, Running Write Policy: %s)." % (lunID, writePolicy, runningWritePolicy)
                continue
            
        return (flag, allCliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[LUNWritePolicy] catch except of check LUN write policy.")
        PY_LOGGER.error("Sequence[LUNWritePolicy] catch except of argument:" + unicode((exception.args)))
        PY_LOGGER.error("Sequence[LUNWritePolicy] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[LUNWritePolicy] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = u"\nQuery result is abnormal."
        return (flag, allCliRet, errMsg)
