# -*- coding: UTF-8 -*-
import traceback
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = ""
        errMsg = ""
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show port general physical_type=ETH logic_type=Management_Port")
        
        if not util.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return False, cliRet, errMsg
        
        ethPortList = util.formatList(cliRet)
        for ethPort in ethPortList:
            ethPortID = ethPort.get("ID")
            healthStatus = ethPort.get("Health Status")
            runningStatus = ethPort.get("Running Status")
            
            if healthStatus != "Normal":
                flag = False
                if "zh" == lang:
                    errMsg += u"\n管理网口[%s]健康状态异常（%s）。" % (ethPortID, healthStatus)
                else:   
                    errMsg += "\nThe health status of management port[%s] is abnormal(%s)." % (ethPortID, healthStatus)
                continue
            
            if runningStatus != "Link Up":
                flag = False
                if "zh" == lang:
                    errMsg += u"\n管理网口[%s]运行状态异常（%s）。" % (ethPortID, runningStatus)
                else:   
                    errMsg += "\nThe running status of management port[%s] is abnormal(%s)." % (ethPortID, runningStatus)
                continue
            else:
                workingRate = ethPort.get("Working Rate(Mbps)")
                if workingRate not in ["100", "1000"]:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\n管理网口[%s]速率异常（%sMbps）。" % (ethPortID, workingRate)
                    else:
                        errMsg += "\nThe speed of management port[%s] is abnormal(%sMbps)." % (ethPortID, workingRate)
                continue
              
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[ManageETHPort] catch except of check manage port port.")
        PY_LOGGER.error("Sequence[ManageETHPort] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[ManageETHPort] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[ManageETHPort] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)

