# -*- coding: UTF-8 -*-
import traceback
import re
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = ""
        errMsg = ""
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show port general physical_type=PCIE")
                
        if not util.checkCliInfoValid(cliRet, False) :
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return False, cliRet, errMsg
        
        pciePortList = util.formatList(cliRet)
        if not pciePortList:
            cliRetItem = cli.execCmd("show enclosure |filterRow column=Logic\sType predict=equal_to value=Engine")
            if not util.checkCliInfoValid(cliRetItem, True) :
                if lang == "zh":
                    errMsg = u"\n查询控制框数量失败。"
                else:
                    errMsg = "\nFailed to query the number of controller enclosures."
                return False, cliRet + cliRetItem, errMsg
            
            ctrlCount = len(util.formatList(cliRetItem))
            if ctrlCount != 1:
                if "zh" == lang:
                    errMsg += u"\n未查询到PCIe接口卡。" 
                else:
                    errMsg += u"The PCIe card being queried does not exist."
                return False, cliRet, errMsg
        else:
            for pciePort in pciePortList:
                pciePortID = pciePort.get("ID")
                healthStatus = pciePort.get("Health Status")
                if healthStatus != "Normal":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nPCIe端口[%s]健康状态异常（%s）。" % (pciePortID, healthStatus)
                    else:
                        errMsg += "\nThe health status of PCIe port[%s] is abnormal(%s)." % (pciePortID, healthStatus)
        
        return (flag, cliRet, errMsg)
                                   
    except Exception, exception:
        PY_LOGGER.error("Sequence[PCIePortStatus] catch except of when check PCIe port." + unicode(chkfc_start) + "~~~~over!")
        PY_LOGGER.error("Sequence[PCIePortStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[PCIePortStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[PCIePortStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
