# -*- coding: UTF-8 -*-
import traceback
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show enclosure")
        if not util.checkCliInfoValid(cliRet, True):
            flag = False
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return False, cliRet, errMsg
        
        ctrlEncCount = 0
        existDataSwich = False
        enclosureList = util.formatList(cliRet)
        for enclosureInfo in enclosureList:
            enclosureID = enclosureInfo.get("ID")
            logicType = enclosureInfo.get("Logic Type")
            healthStatus = enclosureInfo.get("Health Status")
            runningStatus = enclosureInfo.get("Running Status")
            
            if logicType == "Engine":
                ctrlEncCount += 1
            elif logicType == "Data Switch":
                existDataSwich = True
                if healthStatus != "Normal" or runningStatus != "Online":
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nPCIe交换机[%s]状态异常（Health Status：%s，Running Status：%s）。" % (enclosureID, healthStatus, runningStatus)
                    else:
                        errMsg += "\nThe status of PCIe switch[%s] is abnormal(Health Status: %s, Running Status: %s)." % (enclosureID, healthStatus, runningStatus)
            else:
                pass
            
        if ctrlEncCount != 1 and not existDataSwich:
            flag = False
            if "zh" == lang:
                errMsg += u"\n未查询到PCIe交换机。" 
            else:
                errMsg += u"The PCIe switch being queried does not exist."

        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[PCIeSwitchStatus] catch except of check enclosure status.")
        PY_LOGGER.error("Sequence[PCIeSwitchStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[PCIeSwitchStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[PCIeSwitchStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
