# -*- coding: UTF-8 -*-
import traceback
import util


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check POOL status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    flag = True
    cliRet = ""
    errMsg = ""
    lang = ""
    try:
        lang = py_java_env.get("lang")
        cliRet = cli.execCmd("show storage_pool general")
        
        #中文回显 modify 20140623 begin
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                flag = True
            return (flag, cliRet, errMsg)

        listNormalRunning = ["online", "balancing"]
        formatedDictList = util.formatList(cliRet)
        for i in range(len(formatedDictList)):
            poolID = unicode(formatedDictList[i].get("ID"))
            healthStatus = unicode(formatedDictList[i].get("Health Status"))
            runningStatus = unicode(formatedDictList[i].get("Running Status"))
            #modified 20140327 begin
            if ("normal" != healthStatus.lower() or runningStatus.lower() not in listNormalRunning):
                PY_LOGGER.info("Sequence[PoolStatus] inspect pool, health status:" + healthStatus + ", running status:" + runningStatus)
                flag = False
                if "zh" == lang:
                    errMsg += u"\nPool[%s]状态异常（Health Status：%s，Running Status：%s）。" % (poolID, healthStatus, runningStatus)
                else:
                    errMsg += "\nThe status of pool[%s] is abnormal(Health Status: %s, Running Status: %s)." % (poolID, healthStatus, runningStatus)
            #modified 20140327 end
        #中文回显 modify 20140623 end
        
        return(flag, cliRet, errMsg)
    except:
        PY_LOGGER.error("Sequence[PoolStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
