# -*- coding: UTF-8 -*-
import traceback
import re
import util
import hardware

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show power_supply |filterColumn include colunmList=ID,Health\\sStatus,Running\\sStatus,Serial\\sNumber")
        
        lines = cliRet.splitlines()
        for field in lines:
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[PowerStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[PowerStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
        powerList = util.formatList(cliRet)
        for powerDetail in powerList:
            powerID = powerDetail.get("ID")
            enclosureId = powerID.split(".")[0]
            healthStatus = powerDetail.get("Health Status")
            runningStatus = powerDetail.get("Running Status")
            standardBomCode = hardware.getPowerBomCodeByEncId(enclosureId,cliRet)
            if healthStatus != "Normal" or runningStatus != "Online":
                flag = False
                if "zh" == lang:
                    errMsg += u"\n电源[%s]状态异常（Health Status：%s，Running Status：%s）。" % (powerID, healthStatus, runningStatus)
                    if standardBomCode:
                        errMsg += u"\n硬件（电源ID：" + powerID\
                                      + u"）的BOM编码（" + standardBomCode + u"）。" 
                    else:
                        errMsg += u"\n无法获取硬件（电源ID" + powerID\
                              + u"）的BOM编码。" 
                else:
                    errMsg += "\nThe status of power supply[%s] is abnormal(Health Status: %s, Running Status: %s)." % (powerID, healthStatus, runningStatus)
                    if standardBomCode:
                        errMsg += u"\nBOM number 0f hardware(power-id:" + powerID\
                                          + u"):" + standardBomCode + u"." 
                    else:
                        errMsg += u"\nCannot obtain the BOM number of the hardware(power-id: " +  powerID\
                                          + u")." 
         
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[PowerStatus] catch except of check power_supply.")
        PY_LOGGER.error("Sequence[PowerStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[PowerStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[PowerStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
