# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check product version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = False
        lang = py_java_env.get("lang")
        errMsg = ""
        #Optimize check rate
        cliRet = py_java_env.get("showSystemGeneral")
        if None == cliRet:
            cliRet = cli.execCmd("show system general")
            py_java_env.put("showSystemGeneral", cliRet)
        PY_LOGGER.info("\nSequence[ProductVersion] execute command result:\n" + unicode(cliRet))
        
        lines = cliRet.splitlines()
        for field in lines:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[ProductVersion] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[ProductVersion]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("ProductVersion"):
                if field.replace("ProductVersion:", "").find("V200R002C00") != -1:
                    flag = True
                    return (flag, cliRet, errMsg)
                else:
                    PY_LOGGER.info("Sequence[ProductVersion] Inspect product version is: " + field)
                    
        if "zh" == lang:
            errMsg = u"\n系统版本异常。"
        else:
            errMsg = "\nThe version of system is not correct."
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[ProductVersion] catch except of check product version.")
        PY_LOGGER.error("Sequence[ProductVersion] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[ProductVersion] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[ProductVersion] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
