# -*- coding: UTF-8 -*-
import traceback
import util

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        cliRet = ""
        errMsg = ""
        lang = py_java_env.get("lang")
        #Optimize check rate
        cliRet = cli.execCmd("show port general physical_type=SAS")
        
        if not util.checkCliInfoValid(cliRet, False):
            flag = False
            if lang == "zh":
                errMsg = u"\n无效CLI信息。"
            else:
                errMsg = "\nInvalid Cli information."
            return False, cliRet, errMsg
        
        linkupNumA = 0
        linkupNumB = 0
        sasPortList = util.formatList(cliRet)
        for sasPort in sasPortList:
            sasPortID = sasPort.get("ID")
            healthStatus = sasPort.get("Health Status")
            runningStatus = sasPort.get("Running Status")
            
            if healthStatus == "Normal":
                if runningStatus == "Link Down" or runningStatus == "Running":
                    continue
                elif runningStatus == "Link Up":
                    if ".A" in sasPortID:
                        linkupNumA += 1
                    else:
                        linkupNumB += 1
                else:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\nSAS端口[%s]运行状态异常（%s）。" % (sasPortID, runningStatus)
                    else:
                        errMsg += "\nThe running status of SAS port[%s] is abnormal(%s)." % (sasPortID, runningStatus)
            else:
                flag = False
                if "zh" == lang:
                    errMsg += u"\nSAS端口[%s]健康状态异常（%s）。" % (sasPortID, healthStatus)
                else:
                    errMsg += "\nThe health status of SAS port[%s] is abnormal(%s)." % (sasPortID, healthStatus)
            
        if linkupNumA != linkupNumB:
            flag = False
            if "zh" == lang:
                errMsg += u"\nSAS线缆连接不对称，A和B端口link up数量要相等。"
            else:
                errMsg += "\nThe link up of SAS port is not symmetrical, the link up number of port A and port B must be equaled."
        
        return (flag, cliRet, errMsg)
                                   
    except Exception, exception:
        PY_LOGGER.error("Sequence[SASPort] catch except of when check SAS port.")
        PY_LOGGER.error("Sequence[SASPort] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[SASPort] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[SASPort] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
