# -*- coding: UTF-8 -*-
import traceback
import re
import util 


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check SES version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[SESVersionConsistency] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[SESVersionConsistency] execute command result:\n" + unicode(cliRet))

        #Check controller ses vesion
        versionCtrTrace = []
        list1 = cliRet.splitlines()
        for field in list1:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[SESVersionConsistency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[SESVersionConsistency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified Begin
            if field.startswith("SESVersion:"):
                versionCtrTrace.append(field.replace("SESVersion:", ""))
         
        #大小排序   
        sesCtrlVersionSort = sorted(list(set(versionCtrTrace)))
        
        #判断控制器SES版本是否一致
        if len(sesCtrlVersionSort) > 1:
            flag = False 
            if "zh" == lang:
                errMsg += u"\n控制器SES版本不一致：" + u"，".join(sesCtrlVersionSort) + u"。"
            else:
                errMsg += "\nThe SES version of controller is different: " + ", ".join(sesCtrlVersionSort) + "."
        #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified End

        #Check enclosure ses vesion
        versionEncTrace = []
        list2 = cliRet.splitlines()
        str4ExpansionInCliRet = ""
        startFalg = False
        for field in list2:
            if field.startswith("Expansion"):
                startFalg = True
                continue

            if field.startswith("BBU:"):
                startFalg = False
                
            if startFalg:
                str4ExpansionInCliRet += field + "\n"
                
        expansionList = util.formatStr(str4ExpansionInCliRet)
        for i in range(len(expansionList)):
            str4ExpVersion = expansionList[i].get("SES Version")
            str4ExpId = expansionList[i].get("ID")
            if "" == str4ExpVersion.strip():
                flag = False
                PY_LOGGER.info("Sequence[SESVersionConsistency] inspect expSES version, get version of expSES failed")
                if "zh" == lang:
                    errMsg += u"\n级联模块[" + str4ExpId + u"]SES版本查询失败。"
                else:
                    errMsg += "\nFailed to get the version of expansion module[" + str4ExpId + "]."
            else:
                versionEncTrace.append(str4ExpVersion)
        
        sesEncVersionSort = sorted(list(set(versionEncTrace)))
        
        #判断级联框SES版本是否一致
        if len(sesEncVersionSort) > 1:
            flag = False
            
            if "zh" == lang:
                errMsg += u"\n级联框SES版本不一致：" + u'，'.join(sesEncVersionSort) + u"。"
            else:
                errMsg += "\nThe SES version of expansion module is different: " + ', '.join(sesEncVersionSort) + "."
        #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified End
                       
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[SESVersionConsistency] catch except of check SES version.")
        PY_LOGGER.error("Sequence[SESVersionConsistency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[SESVersionConsistency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[SESVersionConsistency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
