# -*- coding: UTF-8 -*-
from commonFunction import getProductFullVersion


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    javaEnv = py_java_env
    logger = PY_LOGGER
    lang = javaEnv.get("lang")
    
    getSucc, cliRet, fullVer = getProductFullVersion(cli, logger)
    if not getSucc:
        if "zh" == lang:
            errMsg = u"\n查询系统版本号失败。"
        else:
            errMsg = u"\nFailed to query the system product version."
        return (False, cliRet, errMsg)    
    
    logger.info('Current system product version:' + unicode(fullVer))
      
    if fullVer < 'V200R002C00SPC200':
        if "zh" == lang:
            errMsg = u"\n当前系统版本低于V200R002C00SPC200。"
        else:
            errMsg = u"\nCurrent system version is lower than V200R002C00SPC200."
        return ('WARNING', cliRet, errMsg)
    else:
        logger.info('Current system product version:' + unicode(fullVer))
        return (True, cliRet, '')
