# -*- coding: UTF-8 -*-
import util
import traceback


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
    
        cliRet = cli.execCmd("show system general")
        lines = cliRet.splitlines()
        if len(lines) < 5:
            if not util.checkCliInfoValid(cliRet, True):
                flag = False
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                flag = True       
            return (flag, cliRet, errMsg)  
        
        SystemDict = util.formatStr(cliRet)    
        HealthStatus = SystemDict.get("Health Status")
        RunningStatus = SystemDict.get("Running Status")    
        if "Normal" not in HealthStatus or "Normal" not in RunningStatus:
            flag = False
            if "zh" == lang:
                errMsg += u"\n系统状态异常（Health Status：" + HealthStatus + u"，Running Status：" + RunningStatus + u"）。"
            else:
                errMsg += "\nThe system runs abnormally(Health Status: " + HealthStatus + ", Running Status: " + RunningStatus + ")."
        return (flag, cliRet, errMsg)
    except Exception, exception:
        PY_LOGGER.error("Sequence[SystemStatus] catch except of check System status.")
        PY_LOGGER.error("Sequence[SystemStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[SystemStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[SystemStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)