# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check software version
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        #Optimize check rate
        cliRet = "default"
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = py_java_env.get("showVersionAll")
        if cliRet == None or cliRet == "default":
            PY_LOGGER.info("Sequence[SystemVersionConsistency] execute command: \"show version all\".")
            cliRet = cli.execCmd("show version all")
            py_java_env.put("showVersionAll", cliRet)
        PY_LOGGER.info("\nSequence[SystemVersionConsistency] execute command result:\n" + unicode(cliRet))
          
        versionTrace = []  
        lines = cliRet.splitlines()
        
        isSwitchOn = False
        for field in lines:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[SystemVersionConsistency] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[SystemVersionConsistency]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified Begin
            #遇到"Controller:"就打开开关
            if re.search("Controller:", field, re.IGNORECASE):
                isSwitchOn = True
            #遇到"Expansion Module:"就关闭开关并退出循环
            if re.search("ExpansionModule:|BBU:", field, re.IGNORECASE):
                isSwitchOn = False
                break
            if isSwitchOn:
                if field.startswith("SoftwareVersion:"):
                    versionTrace.append(field.replace("SoftwareVersion:", ""))
         
        #大小排序   
        softVersionSort = sorted(list(set(versionTrace)))
        
        #判断控制器软件版本是否一致
        if len(softVersionSort) > 1:
            flag = False 
            if "zh" == lang:
                errMsg += u"\n控制器软件版本不一致：" + u'，'.join(softVersionSort) + u"。"
            else:
                errMsg += "\nThe software version of controller is different: " + ', '.join(softVersionSort) + "."
        #需要检查所有的在位版本是否一致，一致则通过，2013/12/16，Modified End
        return (flag, cliRet, errMsg)
            
    except Exception, exception:
        PY_LOGGER.error("Sequence[SystemVersionConsistency] catch except of check software version.")
        PY_LOGGER.error("Sequence[SystemVersionConsistency] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[SystemVersionConsistency] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[SystemVersionConsistency] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
