# -*- coding: UTF-8 -*-
from commonFunction import getProductFullVersion
from commonFunction import parseHotPatchVersion
from commonFunction import checkThinLUNExist


def execute(cli):
    """
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    
    javaEnv = py_java_env
    logger = PY_LOGGER
    lang = javaEnv.get("lang")
    
    isCheckSuccess, cliRet, isThinLunExist = checkThinLUNExist(cli, logger)
    if not isCheckSuccess:
        if "zh" == lang:
            errMsg = u"\n查询Thin LUN信息失败。"
        else:
            errMsg = u"\nFailed to query Thin LUN information."
        return (False, cliRet, errMsg)    
    
    if not isThinLunExist:
        logger.info('Thin LUN not exist.')
        return (True, cliRet, '')
    
    getSucc, sysVerCliRet, fullVer = getProductFullVersion(cli, logger)
    cliRet += sysVerCliRet
    if not getSucc:
        if "zh" == lang:
            errMsg = u"\n查询系统版本号失败。"
        else:
            errMsg = u"\nFailed to query the system product version."
        return (False, cliRet, errMsg)    
    
    logger.info('Current system product version:' + unicode(fullVer))
      
    if fullVer < 'V200R002C00SPC400':
        if "zh" == lang:
            errMsg = u"\n当前系统版本低于V200R002C00SPC400。"
        else:
            errMsg = u"\nCurrent system version is lower than V200R002C00SPC400."
        return ('WARNING', cliRet, errMsg)
    elif fullVer > 'V200R002C00SPC400':
        logger.info('Current system product version:' + unicode(fullVer))
        return (True, cliRet, '')
    else :
        isQryHotpathVerOk, hotPatchVer = parseHotPatchVersion(cliRet, logger)
        if not isQryHotpathVerOk:
            if "zh" == lang:
                errMsg = u"\n查询热补丁版本号失败。"
            else:
                errMsg = u"\nFailed to query the hot patch version."
            return (False, cliRet, errMsg)
        else:
            if hotPatchVer == '--':
                if "zh" == lang:
                    errMsg = u"\n系统未安装热补丁。"
                else:
                    errMsg = u"\nHot patch has not been installed."
                return ('WARNING', cliRet, errMsg)
            elif hotPatchVer >= 'V200R002C00SPH402':
                return (True, cliRet, '')
            else:
                if "zh" == lang:
                    errMsg = u"\n热补丁版本低于V200R002C00SPH402。"
                else:
                    errMsg = u"\nThe version of hot patch is lower than V200R002C00SPH402."
                return ('WARNING', cliRet, errMsg)
