# -*- coding: UTF-8 -*-
import traceback
import re

def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : check Tier status
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = ""
        cliRet1 = ""
        cliRet1 = cli.execCmd("show storage_pool general")

        lines = cliRet1.splitlines()
        i = 0
        for field1 in lines:
            #Need enter to CLI and must in normal mode.
            if field1.startswith("-bash") or field1.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[TierStatus] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet1, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field1, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[TierStatus]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet1, errMsg)
        
            i = i + 1
            if i > 4:
                list1 = field1.split()

                #Find to the end
                if(-1 != list1[0].find(":/>")):
                    break

                #Find right lines and show each POOL_ID
                if(len(list1) >= 6):
                    cliRet2 = cli.execCmd("show storage_pool tier pool_id=" + unicode(list1[0]))
                    cliRet = cliRet + cliRet2
                    PY_LOGGER.info("Sequence[TierStatus] show storage_pool tier ID is:" + unicode(list1[0]))
                    listTier = cliRet2.splitlines()

                    tierName = ""
                    for field2 in listTier:
                        field2 = field2.replace(" ", "")
                        
                        if field2.startswith("Name:"):
                            tierName = field2.replace("Name:", "")
                            continue
                        
                        #HealthStatus equal to normal is OK
                        if field2.startswith("HealthStatus:"):
                            if field2.replace("HealthStatus:", "") not in ["normal", "Normal"]:
                                flag = False
                                healthStatus = unicode(field2.split(':')[-1].strip())
                                if "zh" == lang:
                                    errMsg += u"\nPool[" + list1[0] + u"]名称为[" + tierName + u"]的Tier健康状态异常（" + healthStatus + u"）。"
                                else:
                                    errMsg += "\nThe health status of tier named[" + tierName + "] in pool[" + list1[0] + "] is abnormal(" + healthStatus + ")."
                            
                        #RunningStatus equal to normal is OK
                        if field2.startswith("RunningStatus:"):
                            if field2.replace("RunningStatus:", "") not in ["online", "Online"]:
                                flag = False
                                runningStatus = unicode(field2.split(':')[-1].strip())
                                if "zh" == lang:
                                    errMsg += u"\nPool[" + list1[0] + u"]名称为[" + tierName + u"]的Tier运行状态异常（" + runningStatus + u"）。"
                                else:
                                    errMsg += "\nThe running status of tier named[" + tierName + "] in pool[" + list1[0] + "] is abnormal(" + runningStatus + ")." 
                            
        return(flag, cliRet1 + cliRet, errMsg)
    
    except Exception, exception:
        PY_LOGGER.error("Sequence[TierStatus] catch except of check Tier status.")
        PY_LOGGER.error("Sequence[TierStatus] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[TierStatus] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[TierStatus] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet1 + cliRet, errMsg)
