# -*- coding: UTF-8 -*-
import traceback
import re


def execute(cli):
    """
    Create date        : 2012/05/18,Modify date:2012/06/12
    Function name      : execute(cliConnection)
    Function describe  : execute warning alarm check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show alarm level=warning number=10")
        lines = cliRet.splitlines()
        i = 0
        for field in lines:
            field = field.replace(" ", "")
            #Need enter to CLI and must in normal mode.
            if field.startswith("-bash") or field.startswith("upgrade"):
                flag = False
                PY_LOGGER.info("Sequence[WarningAlarm] not in CLI mode, out!")
                if "zh" == lang:
                    errMsg = u"\n系统没有运行在admin模式。"
                else:
                    errMsg = "\nSystem is not in admin Mode."
                return (flag, cliRet, errMsg)
            #其它出现“Error:”字眼的信息视为不通过
            if re.search("Error:", field, re.IGNORECASE):
                flag = False
                PY_LOGGER.info("There is an error in Sequence[WarningAlarm]!")
                if "zh" == lang:
                    errMsg = u"\n获取信息出错。"
                else:
                    errMsg = "\nThere is an error in getting information."
                return (flag, cliRet, errMsg)
            
            if field.startswith("Commandexecutedsuccessfully"):
                flag = True
                return (flag, cliRet, errMsg)
            i = i + 1
        #If more than 3 lines its means have warning alarm
        if i > 3:
            flag = False
            if "zh" == lang:
                errMsg = u"\n系统存在警告告警。"
            else:
                errMsg = "\nSystem exists warning alarm."
            return (flag, cliRet, errMsg)
        return (flag, cliRet, errMsg)

    except Exception, exception:
        PY_LOGGER.error("Sequence[WarningAlarm] catch except of check warning alarm.")
        PY_LOGGER.error("Sequence[WarningAlarm] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[WarningAlarm] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[WarningAlarm] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
