# -*- coding: UTF-8 -*-
import traceback
import re
import util
import cliCmdManager

def execute(cli):
    """
    硬盘的固件版本检查
    1 如果硬盘的检查标准满足以下条件之一，则检查结果为建议优化。
     1） Model为HUS156060VLS600，且Firmware Version为A510,A760其中之一；
     2） Model为HUS156060VLF400，且Firmware Version为fT02,F510其中之一；"""
    flag = True
    lang = py_java_env.get("lang")
    errMsg = ""
    cliRet = ""
    bugDiskIDList = []
    #存在问题的固件Model与对应的FW
    bugFWVersionMap = {
                    "HUS156060VLS600":("A510","A760"),
                    "HUS156060VLF400":("FT02","F510"),
                    }

    #存放无法获取固件版本值的硬盘
    errInfoDiskIDList = []  
    try:
        cmd = "show disk general |filterColumn include columnList=ID,Model,Firmware\\sVersion"
        cliRet = cli.execCmd(cmd)
        #TV2部分版本过滤命令colunmList字段拼写存在bug，需要兼容
        if not cliCmdManager.hasCliExecPrivilege(cliRet):
            newCmd = "show disk general|filterColumn include colunmList=ID,Model,Firmware\\sVersion"
            cliRet = cli.execCmd(newCmd)

        lineList = cliRet.splitlines()
        if len(lineList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                message = {"zh":u"\n获取信息失败。",
                           "en":"\nThere is an error in getting information.",
                           }
                errMsg = message.get(lang)
            return (flag, cliRet, errMsg)

        diskList = util.formatList(cliRet)
        for diskDict in diskList:
            diskID = diskDict.get("ID","")
            model = diskDict.get("Model","")
            FWVersion = diskDict.get("Firmware Version","")
            bugVersionList = bugFWVersionMap.get(model)
            if FWVersion == "" or FWVersion == "--":
                errInfoDiskIDList.append(diskID)
                continue
            if not bugVersionList:
                continue
            if diskID and (FWVersion.upper() in bugVersionList):
                bugDiskIDList.append(diskID)
        PY_LOGGER.info("bugDiskIDList:" + str(bugDiskIDList))
        
        #将固件版本有问题的DISK信息打印出来
        if bugDiskIDList:
            flag = util.RESULT_WARNING
            message = {"zh":u"\n固件版本较低的硬盘如下：\n%s",
                       "en":"\nDisks whose firmware versions are too early are as follows: \n%s",
                      }
            errMsg = message.get(lang) % ", ".join(bugDiskIDList)
        if errInfoDiskIDList:
            flag = False
            message = {"zh":u"\n无法获取固件版本的硬盘如下：\n%s",
                       "en":"\nDisks whose firmware version cannot be obtained are as follows: \n%s",
                      }
            errMsg += message.get(lang) % ", ".join(errInfoDiskIDList)

        return (flag, cliRet, errMsg)
    
    except Exception:
        PY_LOGGER.error("Sequence[Disk Firmware Version] catch except of trace back:" + unicode(traceback.format_exc()))
        flag = False
        message = {"zh":u"\n查询结果异常。",
                   "en":"\nQuery result is abnormal.",
                   }
        errMsg = message.get(lang)
        return (flag, cliRet, errMsg)
