# -*- coding: UTF-8 -*-
import traceback
import util


def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    try:
        flag = True
        lang = py_java_env.get("lang")
        errMsg = ""
        cliRet = cli.execCmd("show port general physical_type=ETH logic_type=Host_Port")
        
        cmdRetList = cliRet.splitlines()
        if len(cmdRetList) < 5:
            if not util.checkCliInfoValid(cliRet, False):
                flag = False
                if lang == "zh":
                    errMsg = u"\n无效CLI信息。"
                else:
                    errMsg = "\nInvalid Cli information."
            else:
                #包含不存在的情况
                flag = True
            return (flag, cliRet, errMsg)
        
        formatedDictList = util.formatList(cliRet)
        for dictHostPort in formatedDictList:
            if dictHostPort.get("Health Status") != "Normal":
                flag = False
                if "zh" == lang:
                    errMsg += u"\niSCSI端口[" + dictHostPort.get("ID") + u"]健康状态异常（" + dictHostPort.get("Health Status") + u"）。"
                else:
                    errMsg += "\nThe health status of iSCSI port [" + dictHostPort.get("ID") + "] is abnormal(" + dictHostPort.get("Health Status") + ")." 
                continue
            elif dictHostPort.get("Running Status") == "Link Up" or dictHostPort.get("Running Status") == "Running":
                if dictHostPort.get("Working Rate(Mbps)") not in ["10", "100", "1000", "10000"]:
                    flag = False
                    if "zh" == lang:
                        errMsg += u"\niSCSI端口[" + dictHostPort.get("ID") + u"]速率异常（" + dictHostPort.get("Working Rate(Mbps)") + u"Mbps）。"
                    else:
                        errMsg += "\nThe speed of iSCSI port[" + dictHostPort.get("ID") + "] is abnormal(" + dictHostPort.get("Working Rate(Mbps)") + "Mbps)."
                    continue
            elif dictHostPort.get("Running Status") == "Link Down":
                continue
            else:
                flag = False
                if "zh" == lang:
                    errMsg += u"\niSCSI端口[" + dictHostPort.get("ID") + u"]运行状态异常（" + dictHostPort.get("Running Status") + u"）。"
                else:
                    errMsg += "\nThe running status of iSCSI port[" + dictHostPort.get("ID") + "] is abnormal(" + dictHostPort.get("Running Status") + ")."
                continue
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        PY_LOGGER.error("Sequence[iSCSIPort] catch except of when checking iSCSi port.")
        PY_LOGGER.error("Sequence[iSCSIPort] catch except of argument:" + unicode(exception.args))
        PY_LOGGER.error("Sequence[iSCSIPort] catch except of messages:" + unicode(exception))
        PY_LOGGER.error("Sequence[iSCSIPort] catch except of trace back:" + unicode(traceback.print_exc()))
        flag = False
        if "zh" == lang:
            errMsg = u"\n查询结果异常。"
        else:
            errMsg = "\nQuery result is abnormal."
        return (flag, cliRet, errMsg)
