#coding: UTF-8
import cliModeManager
import traceback
import util
from toolutilities import sshutils
from commonFunction import copyDevNode
from commonFunction import getCtrlCmdMode
from constant import SSH_CLI_MODEL_TYPE
from constant import CREATE_SSH_FAIL_REASON_ZH
from constant import CREATE_SSH_FAIL_REASON_EN

#程序入口，以admin用户登录设备
def execute(cli):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """

    javaEnv = py_java_env
    logger = PY_LOGGER
    lang = javaEnv.get("lang")
    cliRet = ""
    errMsg = ""
    devNode = javaEnv.get("devInfo")
    currentIP = devNode.getIp()
    usrPwd = devNode.getLoginUser().getPassword()
    devPwd = unicode(javaEnv.get("devPwd").get("developer"))

    if not devPwd:
        if "zh" == lang:
            errMsg = u"\n获取调试密码为空，请确定是否已配置密码。"
        else:
            errMsg = "\nThe debug password is blank. Please confirm that the password is set."
        return (False, cliRet, errMsg)
    
    cliRetItem = cli.execCmd("show controller ip")
    cliRet += cliRetItem
    controllerIPDict = util.formatDict(cliRetItem)
    logger.info('controllerIPDict:' + unicode(controllerIPDict) + ", type" + unicode(type(controllerIPDict)) + ", len" + unicode(len(controllerIPDict)))
    ipPairList = getControllerIP(controllerIPDict)
    logger.info('IP List:' + unicode(ipPairList))
    
    #将检查结果存为字典，key是ip，value是检查结果的布尔值
    checkCtrlsResultMap = {}
    for engineIpPair in ipPairList:
        #第一个引擎
        if currentIP in engineIpPair:
            # 本端
            flagItem, switchSucc, cliRetItem, errMsgItem = checkSingleCtrlProcess(cli, py_java_env, devPwd, currentIP)
            cliRet += "\nController " + currentIP + ":\n" + cliRetItem
            checkCtrlsResultMap[currentIP] = flagItem
            errMsg += errMsgItem
            engineIpPair.remove(currentIP)
            
            #切换minisystem失败，直接返回 。
            if not switchSucc:
                return (False, cliRet, errMsgItem)
            
        
            if len(engineIpPair) > 0:
                #心跳到对端
                peerIp = engineIpPair[0]
                (flag1, cliRet1, errMsg1) = checkPeerCtrlProcess(cli, usrPwd, devPwd, peerIp, logger)
                checkCtrlsResultMap[peerIp] = flag1
                cliRet += cliRet1
                errMsg += errMsg1
            finalCliMode = cliModeManager.changeAnyModel2CliWithLog(cli, logger)
            if finalCliMode == SSH_CLI_MODEL_TYPE.SSH_MINISYSTEM_MODEL:
                logger.error('Exit minisystem mode failed!')
                if "zh" == lang:
                    errMsg = u"\n" + currentIP + u'：退出minisystem失败。'
                else:
                    errMsg = "\n" + currentIP + ': Failed to exit minisystem.'
                checkCtrlsResultMap[currentIP] = False
        else:#其他引擎（双控节点）
            logger.info("Other engine pair:" + unicode(engineIpPair))
            ipNum = len(engineIpPair)
            if ipNum == 1:
                logger.info('This engine has only one controller!')
                localIP = engineIpPair[0]
                localCli = createSshConnection(py_java_env, localIP)
                
                if not localCli:
                    logger.info('Connect to IP:[' + unicode(localIP) + '] failed!')
                    checkCtrlsResultMap[localIP] = False
                    if "zh" == lang:
                        errMsg += u"\n创建到%s的SSH连接失败。" %(localIP) + CREATE_SSH_FAIL_REASON_ZH
                    else:
                        errMsg += "\nFailed to create SSH connection to %s. " %(localIP) + CREATE_SSH_FAIL_REASON_EN
                    continue
                else: 
                    flagItem, switchSucc, cliRetItem, errMsgItem = checkSingleCtrlProcess(localCli, py_java_env, devPwd, localIP)
                    cliRet += cliRetItem
                    checkCtrlsResultMap[localIP] = flagItem
                    errMsg += errMsgItem
                    finalCliMode = cliModeManager.changeAnyModel2CliWithLog(localCli, logger)
                    if finalCliMode == SSH_CLI_MODEL_TYPE.SSH_MINISYSTEM_MODEL:
                        logger.error('Exit minisystem mode failed!')
                        if "zh" == lang:
                            errMsg = u"\n" + localIP + u'：退出minisystem失败。'
                        else:
                            errMsg = "\n" + localIP + ': Failed to exit minisystem.'
                        checkCtrlsResultMap[localIP] = False
                    localCli.close()
            elif ipNum == 2:
                logger.info('This engine has two controllers!')
                localIP = engineIpPair[0]
                peerIP = engineIpPair[1]

                cliCon = createSshConnection(py_java_env, localIP)
                if not cliCon:
                    cliCon = createSshConnection(py_java_env, peerIP)
                    if not cliCon:
                        logger.error('Create SSH all 2nd controller failed:' + unicode(peerIP))
                        if "zh" == lang:
                            errMsg += u"\n创建到%s、%s的SSH连接失败。" %(localIP, peerIP) + CREATE_SSH_FAIL_REASON_ZH
                        else:
                            errMsg += "\nFailed to create SSH connection to %s, %s. " %(localIP, peerIP) + CREATE_SSH_FAIL_REASON_EN
                            
                        checkCtrlsResultMap[localIP] = False
                        checkCtrlsResultMap[peerIP] = False
                        continue
                    else:
                        localIP, peerIP = peerIP, localIP
                    
                #检查本控制器进程
                flagItem, switchSucc, cliRetItem, errMsgItem = checkSingleCtrlProcess(cliCon, py_java_env, devPwd, localIP)
                cliRet += "\nController " + localIP + ":\n" + cliRetItem
                checkCtrlsResultMap[localIP] = flagItem
                errMsg += errMsgItem
                
                #心跳到对端检查对端控制器进程
                flag2, cliRet2, errMsg2 = checkPeerCtrlProcess(cliCon, usrPwd, devPwd, peerIP, logger)
                checkCtrlsResultMap[peerIP] = flag2
                cliRet += cliRet2
                errMsg += errMsg2
                
                finalCliMode = cliModeManager.changeAnyModel2CliWithLog(cliCon, logger)
                if finalCliMode == SSH_CLI_MODEL_TYPE.SSH_MINISYSTEM_MODEL:
                    logger.error('Exit minisystem mode failed!')
                    if "zh" == lang:
                        errMsg = u"\n" + localIP + u'：退出minisystem失败。'
                    else:
                        errMsg = "\n" + localIP + ': Failed to exit minisystem.'
                    checkCtrlsResultMap[localIP] = False
                cliCon.close()
                                                
            else:
                logger.error('Wrong IP number!')

    logger.error("FinalCheckResultFlagMap:" + unicode(checkCtrlsResultMap))
    for key in checkCtrlsResultMap:
        resultValFlag = checkCtrlsResultMap.get(key)
        if not resultValFlag:
            return  False, cliRet, errMsg

    return (True, cliRet, errMsg)

#封装step1 to step4,判断在一个控制器下是否存在os_debug_mode_p残留进程
def checkSingleCtrlProcess(cli, py_java_env, devPwd, ipAdd):
    flag = True
    switchSucc = True      #切换到minisystem成功
    errMsg = ""
    javaEnv = py_java_env
    logger = PY_LOGGER
    lang = javaEnv.get("lang")
    cliRet = ""
    #******密码快过期导致心跳失败 begin！
    if not cliModeManager.changeCliModel2Minisystem(cli, py_java_env, devPwd, logger):
        switchSucc = False
        if "zh" == lang:
            errMsg += u"\n切换到minisystem模式失败，可能的原因是：当前用户不支持minisystem模式、未输入调试密码或调试密码输入错误。请按照如下建议处理：\
            \n（1）如果当前用户不是admin，请使用admin用户登录后重新执行巡检。\
            \n（2）如果当前用户为admin，请检查调试密码是否正确输入，输入正确的调试密码后重新执行巡检。"
        else:
            errMsg += u"\nFailed to switch to the minisystem mode. The reason of failure may be: Current user cannot switch to minisystem model, did not enter a debug password when adding the device or the debug password entered is incorrect.\
            \n(1) If the current user is not user admin, log in as user admin and perform inspection again. \
            \n(2) If the current user is user admin, check whether the debug password is correct. Enter the correct debug password and perform inspection again."
        return (False, switchSucc, cliRet, errMsg)
    else:
        logger.info('Switch to minisystem mode successfully')
    #******密码快过期导致心跳失败 end！
      
    #执行ps -C os_debug_mode_p命令 
    cliRet = cli.execCmd("ps -C os_debug_mode_p")
    if "PID " not in cliRet:
        if lang == "zh":
            errMsg = u"\n控制器 " + ipAdd + u" ：执行ps -C os_debug_mode_p命令失败。"
        else:
            errMsg = u"\nController " + ipAdd + " : Failed to execute ps -C os_debug_mode_p command."
        return (False, switchSucc, cliRet, errMsg) 
    
    lines = cliRet.splitlines()
    for line in lines:    
        items = line.split()
        if len(items) >= 4 and "os_debug_mode_p" in line:
            if items[1].strip() == "?":
                flag = False
                if "zh" == lang:
                    errMsg += u"\n控制器 " + ipAdd + u" 存在minisystem残留进程。" 
                else:
                    errMsg += u"\nController " + ipAdd + " has a minisystem residual process."
                break
      
    return (flag, switchSucc, cliRet, errMsg)

#心跳到对端检查对端控制器的进程残留
def checkPeerCtrlProcess(localCli, usrPwd, devPwd, peerIp, logger):
    cliRet = ''
    errMsg = ''  
    flag = True 
    javaEnv = py_java_env
    lang = javaEnv.get("lang")
    
    model = getCtrlCmdMode(localCli, logger)
    logger.info("model:" + unicode(model))
    
    if model != SSH_CLI_MODEL_TYPE.SSH_MINISYSTEM_MODEL:
        logger.error('Current CLI mode is not minisystem, return!')
        return (False, cliRet, errMsg)
    
    if cliModeManager.heartbeatToPeer(localCli, usrPwd, logger):
        logger.info('Heart beat to peer successfully!')
    else:
        logger.info('Heart beat to peer failed!')
        #******密码快过期导致心跳失败 begin！
        if "zh" == lang:
            errMsg = u"\n心跳到" + unicode(peerIp) + u"失败，可能的原因是系统繁忙、密码错误、可访问IP地址限制。请按照如下建议处理：\
                    \n（1）如果为系统繁忙，请稍后重新执行巡检。\
                    \n（2）如果在巡检过程中密码被修改，请更新密码后重新执行巡检。\
                    \n（3）登录OceanStor DeviceManager或CLI，查看是否设置了可访问IP地址，如果设置了可访问IP地址，请修改可访问IP地址后重新执行巡检。\
                    \n（4）如果仍然心跳失败，请联系技术支持工程师协助处理。"
        else:
            errMsg += u"\nThe heartbeat connection to " + unicode(peerIp) + u" failed, the reason of failure may be:busy system, incorrect password, accessible IP address configured.\
                    \n (1) If the system is busy, perform inspection later. \
                    \n (2) If the password is changed during the inspection, update the password and perform inspection again.\
                    \n (3) Log in to the OceanStor DeviceManager or CLI, and check whether an accessible IP address is configured. If an accessible IP address is configured, modify the IP address and perform inspection again.\
                    \n (4) If the heartbeat connection still fails, contact technical support engineers."
        return (False, cliRet, errMsg)
        #******密码快过期导致心跳失败 end！
    try:
        flag, switchSucc, cliRetItem, errMsg = checkSingleCtrlProcess(localCli, py_java_env, devPwd, peerIp)
        cliRet += "\nController " + peerIp + ":\n" + cliRetItem
    except Exception, e:
        flag = False
        logger.error('Check process exception:' + unicode(e))
    finally:
        cliModeManager.exitFromPeerMinisystem(localCli)
    return (flag, cliRet, errMsg)
                            
def getControllerIP(controllerIPDict):
    controllerIPList = []
    controller0 = []
    controller1 = []
    if type(controllerIPDict) != dict:
        for controllerIPInfo in controllerIPDict:
            controllerID = controllerIPInfo.get("Controller")
            ip = controllerIPInfo.get("IPv4 Address")
            if controllerID.startswith("0"):
                controller0.append(ip)
            elif controllerID.startswith("1"):
                controller1.append(ip)
    else:
        controllerID = controllerIPDict.get("Controller")
        ip = controllerIPDict.get("IPv4 Address")
        if controllerID.startswith("0"):
            controller0.append(ip)
        elif controllerID.startswith("1"):
            controller1.append(ip)
    if controller0:
        controllerIPList.append(controller0)
    if controller1:
        controllerIPList.append(controller1)
    return controllerIPList

def createSshConnection(py_java_env, ipAddr):
    """
    Create date        : 2012/05/18
    Function name      : execute(cliConnection)
    Function describe  : execute item check
    Input              : cli--Telnet access proxy 
    Return             : the checkitem is pass;cli source info
    """
    lang = py_java_env.get("lang")
    errMsg = ""
    logger = PY_LOGGER
    devNode = py_java_env.get("devInfo")
    myDevNode = copyDevNode(devNode)        
    myDevNode.setIp(ipAddr)
    try:
        cliCon = sshutils.createSSHConnectionByDevNode(myDevNode)
        cliCon.connect()
    except:
        logger.error("Create SSH [" + ipAddr + "] connection catch exception:" + unicode(traceback.print_exc()))  
        return None
    else:
        logger.info("Create SSH [" + ipAddr + "] connection successfully!")
        return cliCon